"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlignmentGuide = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _dom = require("../../lib/dom");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/layout_annotations/alignment_guide.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AlignmentGuide = ({
  transformMatrix,
  width,
  height
}) => /*#__PURE__*/_react.default.createElement("div", {
  className: "canvasAlignmentGuide canvasInteractable canvasLayoutAnnotation",
  style: {
    background: 'magenta',
    height,
    marginLeft: -width / 2,
    marginTop: -height / 2,
    position: 'absolute',
    transform: (0, _dom.matrixToCSS)(transformMatrix),
    width
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 21,
    columnNumber: 3
  }
});
exports.AlignmentGuide = AlignmentGuide;
AlignmentGuide.propTypes = {
  height: _propTypes.default.number.isRequired,
  transformMatrix: _propTypes.default.arrayOf(_propTypes.default.number).isRequired,
  width: _propTypes.default.number.isRequired
};