"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDebugRenderer = exports.debugRendererFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/presentation-util-plugin/public");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
var _components = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/canvas_plugin_src/renderers/debug/debug_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const JSON = 'JSON';
const Debug = (0, _public.withSuspense)(_components.LazyDebugRenderComponent);
const strings = {
  getDisplayName: () => _i18n.i18n.translate('xpack.canvas.renderer.debug.displayName', {
    defaultMessage: 'Debug'
  }),
  getHelpDescription: () => _i18n.i18n.translate('xpack.canvas.renderer.debug.helpDescription', {
    defaultMessage: 'Render debug output as formatted {JSON}',
    values: {
      JSON
    }
  })
};
const getDebugRenderer = core => () => ({
  name: 'debug',
  displayName: strings.getDisplayName(),
  help: strings.getHelpDescription(),
  reuseDomNode: true,
  render(domNode, config, handlers) {
    handlers.onDestroy(() => (0, _reactDom.unmountComponentAtNode)(domNode));
    (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundaryProvider, {
      analytics: undefined,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundary, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, (0, _extends2.default)({}, core, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(Debug, {
      parentNode: domNode,
      payload: config,
      onLoaded: handlers.done,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 13
      }
    })))), domNode);
  }
});
exports.getDebugRenderer = getDebugRenderer;
const debugRendererFactory = core => getDebugRenderer(core);
exports.debugRendererFactory = debugRendererFactory;