"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Typeahead = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _suggestions = _interopRequireDefault(require("./suggestions"));
var _click_outside = _interopRequireDefault(require("./click_outside"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/kuery_bar/typeahead/index.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const KEY_CODES = {
  LEFT: 37,
  UP: 38,
  RIGHT: 39,
  DOWN: 40,
  ENTER: 13,
  ESC: 27,
  TAB: 9
};
class Typeahead extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isSuggestionsVisible: false,
      index: null,
      value: '',
      initialValue: ''
    });
    (0, _defineProperty2.default)(this, "incrementIndex", currentIndex => {
      let nextIndex = currentIndex + 1;
      if (currentIndex === null || nextIndex >= this.props.suggestions.length) {
        nextIndex = 0;
      }
      this.setState({
        index: nextIndex
      });
    });
    (0, _defineProperty2.default)(this, "decrementIndex", currentIndex => {
      let previousIndex = currentIndex - 1;
      if (previousIndex < 0) {
        previousIndex = null;
      }
      this.setState({
        index: previousIndex
      });
    });
    (0, _defineProperty2.default)(this, "onKeyUp", event => {
      const {
        selectionStart
      } = event.target;
      const {
        value
      } = this.state;
      switch (event.keyCode) {
        case KEY_CODES.LEFT:
          this.setState({
            isSuggestionsVisible: true
          });
          this.props.onChange(value, selectionStart);
          break;
        case KEY_CODES.RIGHT:
          this.setState({
            isSuggestionsVisible: true
          });
          this.props.onChange(value, selectionStart);
          break;
      }
    });
    (0, _defineProperty2.default)(this, "onKeyDown", event => {
      const {
        isSuggestionsVisible,
        index,
        value
      } = this.state;
      switch (event.keyCode) {
        case KEY_CODES.DOWN:
          event.preventDefault();
          if (isSuggestionsVisible) {
            this.incrementIndex(index);
          } else {
            this.setState({
              isSuggestionsVisible: true,
              index: 0
            });
          }
          break;
        case KEY_CODES.UP:
          event.preventDefault();
          if (isSuggestionsVisible) {
            this.decrementIndex(index);
          }
          break;
        case KEY_CODES.ENTER:
          event.preventDefault();
          if (isSuggestionsVisible && this.props.suggestions[index]) {
            this.selectSuggestion(this.props.suggestions[index]);
          } else {
            this.setState({
              isSuggestionsVisible: false
            });
            this.props.onSubmit(value);
          }
          break;
        case KEY_CODES.ESC:
          event.preventDefault();
          this.setState({
            isSuggestionsVisible: false
          });
          break;
        case KEY_CODES.TAB:
          this.setState({
            isSuggestionsVisible: false
          });
          break;
      }
    });
    (0, _defineProperty2.default)(this, "onBlur", () => {
      const {
        isSuggestionsVisible,
        index,
        value
      } = this.state;
      if (isSuggestionsVisible && this.props.suggestions[index]) {
        this.selectSuggestion(this.props.suggestions[index]);
      } else {
        this.setState({
          isSuggestionsVisible: false
        });
        this.props.onSubmit(value);
      }
    });
    (0, _defineProperty2.default)(this, "selectSuggestion", suggestion => {
      const nextInputValue = this.state.value.substr(0, suggestion.start) + suggestion.text + this.state.value.substr(suggestion.end);
      this.setState({
        value: nextInputValue,
        index: null
      });
      this.props.onChange(nextInputValue, nextInputValue.length);
    });
    (0, _defineProperty2.default)(this, "onClickOutside", () => {
      this.setState({
        isSuggestionsVisible: false
      });
    });
    (0, _defineProperty2.default)(this, "onChangeInputValue", event => {
      const {
        value,
        selectionStart
      } = event.target;
      const hasValue = Boolean(value.trim());
      this.setState({
        value,
        isSuggestionsVisible: hasValue,
        index: null
      });
      if (!hasValue) {
        this.props.onSubmit(value);
      }
      this.props.onChange(value, selectionStart);
    });
    (0, _defineProperty2.default)(this, "onClickInput", event => {
      const {
        selectionStart
      } = event.target;
      this.props.onChange(this.state.value, selectionStart);
    });
    (0, _defineProperty2.default)(this, "onClickSuggestion", suggestion => {
      this.selectSuggestion(suggestion);
      this.inputRef.focus();
    });
    (0, _defineProperty2.default)(this, "onMouseEnterSuggestion", index => {
      this.setState({
        index
      });
    });
    (0, _defineProperty2.default)(this, "onSubmit", () => {
      this.props.onSubmit(this.state.value);
      this.setState({
        isSuggestionsVisible: false
      });
    });
  }
  static getDerivedStateFromProps(props, state) {
    const initialValue = props.initialValue ? props.initialValue : '';
    if (initialValue !== state.initialValue) {
      return {
        value: initialValue,
        initialValue
      };
    }
    return null;
  }
  render() {
    const {
      disabled,
      isLoading,
      placeholder,
      prepend,
      suggestions
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_click_outside.default, {
      onClickOutside: this.onClickOutside,
      style: {
        position: 'relative'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        position: 'relative'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
      "data-test-subj": "headerFilterKuerybar",
      fullWidth: true,
      style: {
        backgroundImage: 'none'
      },
      placeholder: placeholder,
      inputRef: node => {
        if (node) {
          this.inputRef = node;
        }
      },
      disabled: disabled,
      value: this.state.value,
      onKeyDown: this.onKeyDown,
      onKeyUp: this.onKeyUp,
      onChange: this.onChangeInputValue,
      onClick: this.onClickInput,
      onBlur: this.onBlur,
      autoComplete: "off",
      spellCheck: false,
      prepend: prepend,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 11
      }
    }), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
      size: "xs",
      color: "accent",
      position: "absolute",
      style: {
        bottom: 0,
        top: 'initial'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_suggestions.default, {
      show: this.state.isSuggestionsVisible,
      suggestions: suggestions,
      index: this.state.index,
      onClick: this.onClickSuggestion,
      onMouseEnter: this.onMouseEnterSuggestion,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 9
      }
    }));
  }
}
exports.Typeahead = Typeahead;
Typeahead.propTypes = {
  initialValue: _propTypes.default.string,
  isLoading: _propTypes.default.bool,
  disabled: _propTypes.default.bool,
  onChange: _propTypes.default.func.isRequired,
  onSubmit: _propTypes.default.func.isRequired,
  suggestions: _propTypes.default.array.isRequired,
  placeholder: _propTypes.default.string.isRequired,
  prepend: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.node])
};
Typeahead.defaultProps = {
  isLoading: false,
  disabled: false,
  suggestions: []
};