"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaybeViewTraceLink = MaybeViewTraceLink;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _transaction_detail_link = require("../../../shared/links/apm/transaction_detail_link");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _latency_aggregation_types = require("../../../../../common/latency_aggregation_types");
var _get_comparison_enabled = require("../../../shared/time_comparison/get_comparison_enabled");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_details/waterfall_with_summary/maybe_view_trace_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function FullTraceButton({
  isLoading,
  isDisabled
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.apm.fullTraceButton.viewFullTraceButton.ariaLabel', {
      defaultMessage: 'View full trace'
    }),
    "data-test-subj": "apmFullTraceButtonViewFullTraceButton",
    iconType: "apmTrace",
    isLoading: isLoading,
    disabled: isDisabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.apm.transactionDetails.viewFullTraceButtonLabel', {
    defaultMessage: 'View full trace'
  }));
}
function MaybeViewTraceLink({
  isLoading,
  transaction,
  waterfall,
  environment
}) {
  const {
    query,
    query: {
      comparisonEnabled,
      offset
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/transactions/view', '/traces/explorer', '/dependencies/operation');
  const {
    link
  } = (0, _use_apm_router.useApmRouter)();
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const defaultComparisonEnabled = (0, _get_comparison_enabled.getComparisonEnabled)({
    core,
    urlComparisonEnabled: comparisonEnabled
  });
  const latencyAggregationType = 'latencyAggregationType' in query && query.latencyAggregationType || _latency_aggregation_types.LatencyAggregationType.avg;
  if (isLoading || !transaction) {
    return /*#__PURE__*/_react.default.createElement(FullTraceButton, {
      isLoading: isLoading,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 12
      }
    });
  }
  const {
    rootWaterfallTransaction
  } = waterfall;
  // the traceroot cannot be found, so we cannot link to it
  if (!rootWaterfallTransaction) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.transactionDetails.noTraceParentButtonTooltip', {
        defaultMessage: 'The trace parent cannot be found'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(FullTraceButton, {
      isDisabled: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 9
      }
    }));
  }
  const rootTransaction = rootWaterfallTransaction.doc;
  const isRoot = transaction.transaction.id === rootWaterfallTransaction.id;
  const nextEnvironment = (0, _environment_filter_values.getNextEnvironmentUrlParam)({
    requestedEnvironment: rootTransaction.service.environment,
    currentEnvironmentUrlParam: environment
  });

  // the user is already viewing the full trace, so don't link to it
  if (isRoot) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.transactionDetails.viewingFullTraceButtonTooltip', {
        defaultMessage: 'Currently viewing the full trace'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(FullTraceButton, {
      isDisabled: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 9
      }
    }));

    // the user is viewing a zoomed in version of the trace. Link to the full trace
  } else {
    return /*#__PURE__*/_react.default.createElement(_transaction_detail_link.TransactionDetailLink, {
      transactionName: rootTransaction.transaction.name,
      href: link('/services/{serviceName}/transactions/view', {
        path: {
          serviceName: rootTransaction.service.name
        },
        query: {
          ...query,
          latencyAggregationType,
          traceId: rootTransaction.trace.id,
          transactionId: rootTransaction.transaction.id,
          transactionName: rootTransaction.transaction.name,
          transactionType: rootTransaction.transaction.type,
          comparisonEnabled: defaultComparisonEnabled,
          offset,
          environment: nextEnvironment,
          serviceGroup: ''
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(FullTraceButton, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 9
      }
    }));
  }
}