"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildGapsFilter = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFilterForInterval = (hasInterval, field) => {
  if (hasInterval === undefined) {
    return null;
  }
  const fieldFilter = `kibana.alert.rule.gap.${field}: *`;
  return hasInterval ? fieldFilter : `NOT ${fieldFilter}`;
};
const buildGapsFilter = ({
  start,
  end,
  statuses,
  hasUnfilledIntervals,
  hasInProgressIntervals,
  hasFilledIntervals
}) => {
  const baseFilter = 'event.action: gap AND event.provider: alerting AND not kibana.alert.rule.gap.deleted:true';
  const endFilter = end ? `kibana.alert.rule.gap.range <= "${end}"` : null;
  const startFilter = start ? `kibana.alert.rule.gap.range >= "${start}"` : null;
  const statusesFilter = statuses !== null && statuses !== void 0 && statuses.length ? `(${statuses.map(status => `kibana.alert.rule.gap.status : ${status}`).join(' OR ')})` : null;
  const hasUnfilledIntervalsFilter = getFilterForInterval(hasUnfilledIntervals, 'unfilled_intervals');
  const hasInProgressIntervalsFilter = getFilterForInterval(hasInProgressIntervals, 'in_progress_intervals');
  const hasFilledIntervalsFilter = getFilterForInterval(hasFilledIntervals, 'filled_intervals');
  return [baseFilter, endFilter, startFilter, statusesFilter, hasUnfilledIntervalsFilter, hasInProgressIntervalsFilter, hasFilledIntervalsFilter].filter(Boolean).join(' AND ');
};
exports.buildGapsFilter = buildGapsFilter;