"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleBackfillParamsSchema = exports.scheduleBackfillParamSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _common = require("../../../../../../common");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const scheduleBackfillParamSchema = exports.scheduleBackfillParamSchema = _configSchema.schema.object({
  ruleId: _configSchema.schema.string(),
  ranges: _configSchema.schema.arrayOf(_configSchema.schema.object({
    start: _configSchema.schema.string(),
    end: _configSchema.schema.string()
  })),
  runActions: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  initiator: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.backfillInitiator.USER), _configSchema.schema.literal(_constants.backfillInitiator.SYSTEM)]),
  initiatorId: _configSchema.schema.maybe(_configSchema.schema.string())
}, {
  validate({
    ranges,
    initiatorId,
    initiator
  }) {
    const errors = ranges.map(range => (0, _common.validateBackfillSchedule)(range.start, range.end)).filter(Boolean).join('\n');
    if (errors.length > 0) {
      return errors;
    }
    if (initiatorId && initiator !== _constants.backfillInitiator.SYSTEM) {
      return 'Initiator ID can only be used with system initiator';
    }
  }
});
const scheduleBackfillParamsSchema = exports.scheduleBackfillParamsSchema = _configSchema.schema.arrayOf(scheduleBackfillParamSchema, {
  minSize: 1,
  maxSize: _constants.MAX_SCHEDULE_BACKFILL_BULK_SIZE
});