"use strict";
/*
 * ELASTICSEARCH CONFIDENTIAL
 * __________________
 *
 *  Copyright Elasticsearch B.V. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Elasticsearch B.V. and its suppliers, if any.
 * The intellectual and technical concepts contained herein
 * are proprietary to Elasticsearch B.V. and its suppliers and
 * may be covered by U.S. and Foreign Patents, patents in
 * process, and are protected by trade secret or copyright
 * law.  Dissemination of this information or reproduction of
 * this material is strictly forbidden unless prior written
 * permission is obtained from Elasticsearch B.V.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LicenseCheck = exports.LicenseStatus = void 0;
var elasticsearch_1 = require("./elasticsearch");
var config_service_1 = require("./config/config_service");
var LicenseStatus;
(function (LicenseStatus) {
    LicenseStatus["PREVALIDATED"] = "PREVALIDATED";
    LicenseStatus["OK"] = "OK";
    LicenseStatus["INVALID"] = "INVALID";
    LicenseStatus["NOT_FOUND"] = "NOT_FOUND";
    LicenseStatus["CHECKING"] = "CHECKING";
})(LicenseStatus || (exports.LicenseStatus = LicenseStatus = {}));
var ES_UNAVAILABLE = 'Elasticsearch is unavailable. Check server logs for more info.';
var LicenseCheck = /** @class */ (function () {
    function LicenseCheck(clientOptions, minimumRequiredLicense, checkInterval, logger) {
        if (checkInterval === void 0) { checkInterval = 30000; }
        this.clientOptions = clientOptions;
        this.minimumRequiredLicense = minimumRequiredLicense;
        this.checkInterval = checkInterval;
        this.logger = logger;
        this.isValid = LicenseStatus.NOT_FOUND;
        this.clusterDetails = undefined;
        this.shouldCheck = true;
        if (clientOptions.preValidated) {
            this.shouldCheck = false;
            this.isValid = LicenseStatus.PREVALIDATED;
            this.logger.debug({
                message: "License is preValidated",
            });
        }
    }
    LicenseCheck.prototype.init = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!this.shouldCheck) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.check()];
                    case 1:
                        _a.sent();
                        // sleep
                        return [4 /*yield*/, new Promise(function (resolve) { return setTimeout(resolve, _this.checkInterval); })];
                    case 2:
                        // sleep
                        _a.sent();
                        return [3 /*break*/, 0];
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    LicenseCheck.prototype.stopChecking = function () {
        this.shouldCheck = false;
    };
    LicenseCheck.prototype.check = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a, error_1, clusterName, license, isActive, clusterLicense, clusterLicenseLevel, valid, error_2;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (!this.shouldCheck)
                            return [2 /*return*/];
                        _b.label = 1;
                    case 1:
                        _b.trys.push([1, 6, , 7]);
                        this.isValid = LicenseStatus.CHECKING;
                        _b.label = 2;
                    case 2:
                        _b.trys.push([2, 4, , 5]);
                        _a = this;
                        return [4 /*yield*/, (0, elasticsearch_1.getClusterDetails)(this.clientOptions)];
                    case 3:
                        _a.clusterDetails = _b.sent();
                        return [3 /*break*/, 5];
                    case 4:
                        error_1 = _b.sent();
                        this.logger.error({
                            message: "Unable to connect to the Elasticsearch cluster: ".concat((error_1 === null || error_1 === void 0 ? void 0 : error_1.message) || error_1),
                        });
                        throw new Error(ES_UNAVAILABLE);
                    case 5:
                        clusterName = this.clusterDetails.cluster.name;
                        license = this.clusterDetails.license;
                        isActive = license.status === 'active';
                        clusterLicense = license.type;
                        clusterLicenseLevel = config_service_1.ElasticLicense[clusterLicense];
                        if (!clusterLicenseLevel) {
                            this.isValid = LicenseStatus.INVALID;
                            this.error = new Error(ES_UNAVAILABLE);
                            this.logger.error({
                                message: "Your cluster license [".concat(clusterLicense, "] is unknown"),
                            });
                        }
                        valid = isActive && clusterLicenseLevel >= this.minimumRequiredLicense;
                        if (valid) {
                            this.isValid = LicenseStatus.OK;
                            delete this.error;
                            this.logger.debug({
                                message: "License [".concat(clusterLicense, "] for cluster [").concat(clusterName, "] validated"),
                            });
                        }
                        else {
                            this.isValid = LicenseStatus.INVALID;
                            this.error = new Error(ES_UNAVAILABLE);
                            this.logger.error({
                                message: "License [".concat(clusterLicense, "] for cluster [").concat(clusterName, "] is not valid"),
                            });
                        }
                        return [3 /*break*/, 7];
                    case 6:
                        error_2 = _b.sent();
                        this.isValid = LicenseStatus.NOT_FOUND;
                        this.error = new Error(error_2);
                        this.logger.error({ message: error_2.message });
                        return [3 /*break*/, 7];
                    case 7: return [2 /*return*/];
                }
            });
        });
    };
    return LicenseCheck;
}());
exports.LicenseCheck = LicenseCheck;
//# sourceMappingURL=licensecheck.js.map