/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.concurrent.Executor;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;
import org.hamcrest.Matchers;

class BuildHashModifyingTransportInterceptor
implements TransportInterceptor {
    BuildHashModifyingTransportInterceptor() {
    }

    public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(String action, Executor executor, boolean forceExecution, TransportRequestHandler<T> actualHandler) {
        if ("internal:transport/handshake".equals(action)) {
            return (request, channel, task) -> actualHandler.messageReceived(request, new TransportChannel(){

                public String getProfileName() {
                    return channel.getProfileName();
                }

                public void sendResponse(TransportResponse response) {
                    ESTestCase.assertThat(response, Matchers.instanceOf(TransportService.HandshakeResponse.class));
                    TransportService.HandshakeResponse handshakeResponse = (TransportService.HandshakeResponse)response;
                    channel.sendResponse((TransportResponse)new TransportService.HandshakeResponse(handshakeResponse.getVersion(), handshakeResponse.getBuildHash() + "-modified", handshakeResponse.getDiscoveryNode(), handshakeResponse.getClusterName()));
                }

                public void sendResponse(Exception exception) {
                    channel.sendResponse(exception);
                }
            }, task);
        }
        return actualHandler;
    }
}

