/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.tests.index.FieldFilterLeafReader;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.elasticsearch.common.xcontent.support.XContentMapValues;

public class WildcardFieldMaskingReader
extends FilterDirectoryReader {
    private final Set<String> patterns;

    public WildcardFieldMaskingReader(String pattern, DirectoryReader in) throws IOException {
        this(Set.of(pattern), in);
    }

    public WildcardFieldMaskingReader(final Set<String> patterns, DirectoryReader in) throws IOException {
        super(in, new FilterDirectoryReader.SubReaderWrapper(){

            public LeafReader wrap(final LeafReader reader) {
                CharacterRunAutomaton matcher = XContentMapValues.compileAutomaton((String[])((String[])patterns.toArray(String[]::new)), (CharacterRunAutomaton)new CharacterRunAutomaton(Automata.makeAnyString()));
                TreeSet<String> fields = new TreeSet<String>();
                for (FieldInfo fieldInfo : reader.getFieldInfos()) {
                    String fieldName = fieldInfo.name;
                    if (!matcher.run(fieldName)) continue;
                    fields.add(fieldName);
                }
                return new FilterLeafReader(this, (LeafReader)new FieldFilterLeafReader(reader, fields, true)){

                    public IndexReader.CacheHelper getReaderCacheHelper() {
                        return reader.getReaderCacheHelper();
                    }

                    public IndexReader.CacheHelper getCoreCacheHelper() {
                        return reader.getCoreCacheHelper();
                    }
                };
            }
        });
        this.patterns = patterns;
    }

    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
        return new WildcardFieldMaskingReader(this.patterns, in);
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }
}

