/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopLongFloatAggregatorFunction;
import org.elasticsearch.compute.aggregation.TopLongFloatGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopLongFloatAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final int limit;
    private final boolean ascending;

    public TopLongFloatAggregatorFunctionSupplier(int limit, boolean ascending) {
        this.limit = limit;
        this.ascending = ascending;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return TopLongFloatAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return TopLongFloatGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public TopLongFloatAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return TopLongFloatAggregatorFunction.create(driverContext, channels, this.limit, this.ascending);
    }

    @Override
    public TopLongFloatGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return TopLongFloatGroupingAggregatorFunction.create(channels, driverContext, this.limit, this.ascending);
    }

    @Override
    public String describe() {
        return "top_long of floats";
    }
}

