/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesFailure;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.TriConsumer;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverCompletionInfo;
import org.elasticsearch.compute.operator.FailureCollector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesExpressionGrouper;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.crossproject.CrossProjectModeDecider;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.action.EsqlExecutionInfo;
import org.elasticsearch.xpack.esql.action.EsqlQueryRequest;
import org.elasticsearch.xpack.esql.analysis.Analyzer;
import org.elasticsearch.xpack.esql.analysis.AnalyzerContext;
import org.elasticsearch.xpack.esql.analysis.AnalyzerSettings;
import org.elasticsearch.xpack.esql.analysis.EnrichResolution;
import org.elasticsearch.xpack.esql.analysis.PreAnalyzer;
import org.elasticsearch.xpack.esql.analysis.Verifier;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeUtils;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.enrich.EnrichPolicyResolver;
import org.elasticsearch.xpack.esql.expression.function.EsqlFunctionRegistry;
import org.elasticsearch.xpack.esql.index.EsIndex;
import org.elasticsearch.xpack.esql.index.IndexResolution;
import org.elasticsearch.xpack.esql.inference.InferenceResolution;
import org.elasticsearch.xpack.esql.inference.InferenceService;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.LogicalPlanOptimizer;
import org.elasticsearch.xpack.esql.optimizer.LogicalPlanPreOptimizer;
import org.elasticsearch.xpack.esql.optimizer.LogicalPreOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.PhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.PhysicalPlanOptimizer;
import org.elasticsearch.xpack.esql.parser.EsqlParser;
import org.elasticsearch.xpack.esql.parser.QueryParams;
import org.elasticsearch.xpack.esql.plan.EsqlStatement;
import org.elasticsearch.xpack.esql.plan.IndexPattern;
import org.elasticsearch.xpack.esql.plan.QuerySetting;
import org.elasticsearch.xpack.esql.plan.QuerySettings;
import org.elasticsearch.xpack.esql.plan.SettingsValidationContext;
import org.elasticsearch.xpack.esql.plan.logical.Explain;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.join.InlineJoin;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.FragmentExec;
import org.elasticsearch.xpack.esql.plan.physical.LocalSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.planner.mapper.Mapper;
import org.elasticsearch.xpack.esql.planner.premapper.PreMapper;
import org.elasticsearch.xpack.esql.plugin.TransportActionServices;
import org.elasticsearch.xpack.esql.session.Configuration;
import org.elasticsearch.xpack.esql.session.EsqlCCSUtils;
import org.elasticsearch.xpack.esql.session.FieldNameUtils;
import org.elasticsearch.xpack.esql.session.IndexResolver;
import org.elasticsearch.xpack.esql.session.NoClustersToSearchException;
import org.elasticsearch.xpack.esql.session.Result;
import org.elasticsearch.xpack.esql.session.SessionUtils;
import org.elasticsearch.xpack.esql.session.Versioned;
import org.elasticsearch.xpack.esql.telemetry.PlanTelemetry;

public class EsqlSession {
    private static final Logger LOGGER = LogManager.getLogger(EsqlSession.class);
    private static final TransportVersion LOOKUP_JOIN_CCS = TransportVersion.fromName((String)"lookup_join_ccs");
    private final String sessionId;
    private final AnalyzerSettings clusterSettings;
    private final IndexResolver indexResolver;
    private final EnrichPolicyResolver enrichPolicyResolver;
    private final PreAnalyzer preAnalyzer;
    private final Verifier verifier;
    private final EsqlFunctionRegistry functionRegistry;
    private final PreMapper preMapper;
    private final Mapper mapper;
    private final PlanTelemetry planTelemetry;
    private final IndicesExpressionGrouper indicesExpressionGrouper;
    private final InferenceService inferenceService;
    private final RemoteClusterService remoteClusterService;
    private final BlockFactory blockFactory;
    private final ByteSizeValue intermediateLocalRelationMaxSize;
    private final CrossProjectModeDecider crossProjectModeDecider;
    private final String clusterName;
    private boolean explainMode;
    private String parsedPlanString;
    private String optimizedLogicalPlanString;

    public EsqlSession(String sessionId, AnalyzerSettings clusterSettings, IndexResolver indexResolver, EnrichPolicyResolver enrichPolicyResolver, PreAnalyzer preAnalyzer, EsqlFunctionRegistry functionRegistry, Mapper mapper, Verifier verifier, PlanTelemetry planTelemetry, IndicesExpressionGrouper indicesExpressionGrouper, TransportActionServices services) {
        this.sessionId = sessionId;
        this.clusterSettings = clusterSettings;
        this.indexResolver = indexResolver;
        this.enrichPolicyResolver = enrichPolicyResolver;
        this.preAnalyzer = preAnalyzer;
        this.verifier = verifier;
        this.functionRegistry = functionRegistry;
        this.mapper = mapper;
        this.planTelemetry = planTelemetry;
        this.indicesExpressionGrouper = indicesExpressionGrouper;
        this.inferenceService = services.inferenceService();
        this.preMapper = new PreMapper(services);
        this.remoteClusterService = services.transportService().getRemoteClusterService();
        this.blockFactory = services.blockFactoryProvider().blockFactory();
        this.intermediateLocalRelationMaxSize = services.plannerSettings().intermediateLocalRelationMaxSize();
        this.crossProjectModeDecider = services.crossProjectModeDecider();
        this.clusterName = services.clusterService().getClusterName().value();
    }

    public String sessionId() {
        return this.sessionId;
    }

    public void execute(final EsqlQueryRequest request, final EsqlExecutionInfo executionInfo, final PlanRunner planRunner, final ActionListener<Result> listener) {
        assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"search"}));
        assert (executionInfo != null) : "Null EsqlExecutionInfo";
        LOGGER.debug("ESQL query:\n{}", new Object[]{request.query()});
        EsqlStatement statement = this.parse(request.query(), request.params());
        final Configuration configuration = new Configuration(request.timeZone() == null ? statement.setting(QuerySettings.TIME_ZONE) : statement.settingOrDefault(QuerySettings.TIME_ZONE, request.timeZone()), request.locale() != null ? request.locale() : Locale.US, null, this.clusterName, request.pragmas(), this.clusterSettings.resultTruncationMaxSize(), this.clusterSettings.resultTruncationDefaultSize(), request.query(), request.profile(), request.tables(), System.nanoTime(), request.allowPartialResults(), this.clusterSettings.timeseriesResultTruncationMaxSize(), this.clusterSettings.timeseriesResultTruncationDefaultSize());
        final FoldContext foldContext = configuration.newFoldContext();
        LogicalPlan plan = statement.plan();
        if (plan instanceof Explain) {
            Explain explain = (Explain)plan;
            this.explainMode = true;
            plan = explain.query();
            this.parsedPlanString = plan.toString();
        }
        this.analyzedPlan(plan, configuration, executionInfo, request.filter(), new EsqlCCSUtils.CssPartialErrorsActionListener(executionInfo, listener){

            public void onResponse(Versioned<LogicalPlan> analyzedPlan) {
                assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"search", "search_coordination", "system_read"}));
                LogicalPlan plan = analyzedPlan.inner();
                TransportVersion minimumVersion = analyzedPlan.minimumVersion();
                LogicalPlanPreOptimizer logicalPlanPreOptimizer = new LogicalPlanPreOptimizer(new LogicalPreOptimizerContext(foldContext, EsqlSession.this.inferenceService, minimumVersion));
                LogicalPlanOptimizer logicalPlanOptimizer = new LogicalPlanOptimizer(new LogicalOptimizerContext(configuration, foldContext, minimumVersion));
                SubscribableListener.newForked(l -> EsqlSession.this.preOptimizedPlan(plan, logicalPlanPreOptimizer, (ActionListener<LogicalPlan>)l)).andThen((l, p) -> EsqlSession.this.preMapper.preMapper(new Versioned<LogicalPlan>(EsqlSession.this.optimizedPlan((LogicalPlan)((Object)p), logicalPlanOptimizer), minimumVersion), (ActionListener<LogicalPlan>)l)).andThen((l, p) -> EsqlSession.this.executeOptimizedPlan(request, executionInfo, planRunner, (LogicalPlan)((Object)p), configuration, foldContext, minimumVersion, (ActionListener<Result>)l)).addListener(listener);
            }
        });
    }

    public void executeOptimizedPlan(EsqlQueryRequest request, EsqlExecutionInfo executionInfo, PlanRunner planRunner, LogicalPlan optimizedPlan, Configuration configuration, FoldContext foldContext, TransportVersion minimumVersion, ActionListener<Result> listener) {
        assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"search", "search_coordination", "system_read"}));
        PhysicalPlanOptimizer physicalPlanOptimizer = new PhysicalPlanOptimizer(new PhysicalOptimizerContext(configuration, minimumVersion));
        if (this.explainMode) {
            PhysicalPlan physicalPlan = this.logicalPlanToPhysicalPlan(optimizedPlan, request, physicalPlanOptimizer);
            String physicalPlanString = physicalPlan.toString();
            List<ReferenceAttribute> fields = List.of(new ReferenceAttribute(Source.EMPTY, null, "role", DataType.KEYWORD), new ReferenceAttribute(Source.EMPTY, null, "type", DataType.KEYWORD), new ReferenceAttribute(Source.EMPTY, null, "plan", DataType.KEYWORD));
            ArrayList<List<String>> values = new ArrayList<List<String>>();
            values.add(List.of("coordinator", "parsedPlan", this.parsedPlanString));
            values.add(List.of("coordinator", "optimizedLogicalPlan", this.optimizedLogicalPlanString));
            values.add(List.of("coordinator", "optimizedPhysicalPlan", physicalPlanString));
            Block[] blocks = BlockUtils.fromList((BlockFactory)PlannerUtils.NON_BREAKING_BLOCK_FACTORY, values);
            physicalPlan = new LocalSourceExec(Source.EMPTY, fields, LocalSupplier.of(new Page(blocks)));
            planRunner.run(physicalPlan, configuration, foldContext, listener);
        } else {
            EsqlCCSUtils.updateExecutionInfoAtEndOfPlanning(executionInfo);
            this.executeSubPlans(optimizedPlan, configuration, foldContext, planRunner, executionInfo, request, physicalPlanOptimizer, listener);
        }
    }

    private void executeSubPlans(LogicalPlan optimizedPlan, Configuration configuration, FoldContext foldContext, PlanRunner runner, EsqlExecutionInfo executionInfo, EsqlQueryRequest request, PhysicalPlanOptimizer physicalPlanOptimizer, ActionListener<Result> listener) {
        HashSet<LocalRelation> subPlansResults = new HashSet<LocalRelation>();
        InlineJoin.LogicalPlanTuple subPlan = InlineJoin.firstSubPlan(optimizedPlan, subPlansResults);
        if (subPlan != null) {
            this.executeSubPlan(new DriverCompletionInfo.Accumulator(), optimizedPlan, subPlan, configuration, foldContext, executionInfo, runner, request, subPlansResults, physicalPlanOptimizer, (ActionListener<Result>)ActionListener.runAfter(listener, executionInfo::finishSubPlans));
        } else {
            PhysicalPlan physicalPlan = this.logicalPlanToPhysicalPlan(optimizedPlan, request, physicalPlanOptimizer);
            runner.run(physicalPlan, configuration, foldContext, listener);
        }
    }

    private void executeSubPlan(DriverCompletionInfo.Accumulator completionInfoAccumulator, LogicalPlan optimizedPlan, InlineJoin.LogicalPlanTuple subPlans, Configuration configuration, FoldContext foldContext, EsqlExecutionInfo executionInfo, PlanRunner runner, EsqlQueryRequest request, Set<LocalRelation> subPlansResults, PhysicalPlanOptimizer physicalPlanOptimizer, ActionListener<Result> listener) {
        LOGGER.debug("Executing subplan:\n{}", new Object[]{subPlans.stubReplacedSubPlan()});
        PhysicalPlan physicalSubPlan = this.logicalPlanToPhysicalPlan(subPlans.stubReplacedSubPlan(), request, physicalPlanOptimizer);
        executionInfo.startSubPlans();
        runner.run(physicalSubPlan, configuration, foldContext, (ActionListener<Result>)listener.delegateFailureAndWrap((next, result) -> {
            AtomicReference<Page> localRelationPage = new AtomicReference<Page>();
            try {
                completionInfoAccumulator.accumulate(result.completionInfo());
                LocalRelation resultWrapper = this.resultToPlan(subPlans.stubReplacedSubPlan().source(), (Result)result);
                localRelationPage.set((Page)resultWrapper.supplier().get());
                ActionListener releasingNext = ActionListener.runAfter((ActionListener)next, () -> EsqlSession.releaseLocalRelationBlocks(localRelationPage));
                subPlansResults.add(resultWrapper);
                LogicalPlan newMainPlan = EsqlSession.newMainPlan(optimizedPlan, subPlans, resultWrapper);
                InlineJoin.LogicalPlanTuple newSubPlan = InlineJoin.firstSubPlan(newMainPlan, subPlansResults);
                if (newSubPlan == null) {
                    executionInfo.finishSubPlans();
                    LOGGER.debug("Executing final plan:\n{}", new Object[]{newMainPlan});
                    PhysicalPlan newPhysicalPlan = this.logicalPlanToPhysicalPlan(newMainPlan, request, physicalPlanOptimizer);
                    runner.run(newPhysicalPlan, configuration, foldContext, (ActionListener<Result>)releasingNext.delegateFailureAndWrap((finalListener, finalResult) -> {
                        completionInfoAccumulator.accumulate(finalResult.completionInfo());
                        finalListener.onResponse((Object)new Result(finalResult.schema(), finalResult.pages(), completionInfoAccumulator.finish(), executionInfo));
                    }));
                } else {
                    this.executeSubPlan(completionInfoAccumulator, newMainPlan, newSubPlan, configuration, foldContext, executionInfo, runner, request, subPlansResults, physicalPlanOptimizer, (ActionListener<Result>)releasingNext);
                }
            }
            catch (Exception e) {
                EsqlSession.releaseLocalRelationBlocks(localRelationPage);
                throw e;
            }
            finally {
                Releasables.closeExpectNoException((Releasable)Releasables.wrap((Iterator)Iterators.map(result.pages().iterator(), p -> () -> ((Page)p).releaseBlocks())));
            }
        }));
    }

    public static LogicalPlan newMainPlan(LogicalPlan optimizedPlan, InlineJoin.LogicalPlanTuple subPlans, LocalRelation resultWrapper) {
        LogicalPlan newLogicalPlan = (LogicalPlan)optimizedPlan.transformUp(InlineJoin.class, ij -> ij.right() == subPlans.originalSubPlan() ? InlineJoin.inlineData(ij, resultWrapper) : ij);
        newLogicalPlan.setOptimized();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Main plan change after previous subplan execution:\n{}", new Object[]{NodeUtils.diffString((Node)optimizedPlan, (Node)newLogicalPlan)});
        }
        return newLogicalPlan;
    }

    private LocalRelation resultToPlan(Source planSource, Result result) {
        List<Page> pages = result.pages();
        SessionUtils.checkPagesBelowSize(pages, this.intermediateLocalRelationMaxSize, actual -> "sub-plan execution results too large [" + String.valueOf(ByteSizeValue.ofBytes((long)actual)) + "] > " + String.valueOf(this.intermediateLocalRelationMaxSize));
        List<Attribute> schema = result.schema();
        Block[] blocks = SessionUtils.fromPages(schema, pages, this.blockFactory);
        return new LocalRelation(planSource, schema, LocalSupplier.of(blocks.length == 0 ? new Page(0, new Block[0]) : new Page(blocks)));
    }

    private static void releaseLocalRelationBlocks(AtomicReference<Page> localRelationPage) {
        Page relationPage = localRelationPage.getAndSet(null);
        if (relationPage != null) {
            Releasables.closeExpectNoException((Releasable)relationPage);
        }
    }

    private EsqlStatement parse(String query, QueryParams params) {
        EsqlStatement parsed = new EsqlParser().createQuery(query, params, this.planTelemetry);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Parsed logical plan:\n{}", new Object[]{parsed.plan()});
            LOGGER.debug("Parsed settings:\n[{}]", new Object[]{parsed.settings().stream().map(QuerySetting::toString).collect(Collectors.joining("; "))});
        }
        QuerySettings.validate(parsed, SettingsValidationContext.from(this.remoteClusterService));
        return parsed;
    }

    static void handleFieldCapsFailures(boolean allowPartialResults, EsqlExecutionInfo executionInfo, Map<IndexPattern, IndexResolution> indexResolutions) throws Exception {
        FailureCollector failureCollector = new FailureCollector();
        for (IndexResolution indexResolution : indexResolutions.values()) {
            EsqlSession.handleFieldCapsFailures(allowPartialResults, executionInfo, indexResolution.failures(), failureCollector);
        }
        Exception failure = failureCollector.getFailure();
        if (failure != null) {
            throw failure;
        }
    }

    static void handleFieldCapsFailures(boolean allowPartialResults, EsqlExecutionInfo executionInfo, Map<String, List<FieldCapabilitiesFailure>> failures, FailureCollector failureCollector) throws Exception {
        for (Map.Entry<String, List<FieldCapabilitiesFailure>> e : failures.entrySet()) {
            String clusterAlias = e.getKey();
            EsqlExecutionInfo.Cluster cluster = executionInfo.getCluster(clusterAlias);
            if (cluster.getStatus() != EsqlExecutionInfo.Cluster.Status.RUNNING) {
                assert (cluster.getStatus() != EsqlExecutionInfo.Cluster.Status.SUCCESSFUL) : "can't mark a cluster success with failures";
                continue;
            }
            if (!allowPartialResults && !executionInfo.shouldSkipOnFailure(clusterAlias)) {
                for (FieldCapabilitiesFailure failure : e.getValue()) {
                    failureCollector.unwrapAndCollect(failure.getException());
                }
                continue;
            }
            if (!cluster.getFailures().isEmpty()) continue;
            List<ShardSearchFailure> shardFailures = e.getValue().stream().map(f -> {
                ShardId shardId = null;
                Throwable patt0$temp = ExceptionsHelper.unwrapCause((Throwable)f.getException());
                if (patt0$temp instanceof ElasticsearchException) {
                    ElasticsearchException es = (ElasticsearchException)patt0$temp;
                    shardId = es.getShardId();
                }
                if (shardId != null) {
                    return new ShardSearchFailure(f.getException(), new SearchShardTarget(null, shardId, clusterAlias));
                }
                return new ShardSearchFailure(f.getException());
            }).toList();
            executionInfo.swapCluster(clusterAlias, (k, curr) -> new EsqlExecutionInfo.Cluster.Builder(cluster).addFailures(shardFailures).build());
        }
    }

    public void analyzedPlan(LogicalPlan parsed, Configuration configuration, EsqlExecutionInfo executionInfo, QueryBuilder requestFilter, ActionListener<Versioned<LogicalPlan>> logicalPlanListener) {
        assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"search"}));
        PreAnalyzer.PreAnalysis preAnalysis = this.preAnalyzer.preAnalyze(parsed);
        PreAnalysisResult result = FieldNameUtils.resolveFieldNames(parsed, !preAnalysis.enriches().isEmpty());
        String description = requestFilter == null ? "the only attempt without filter" : "first attempt with filter";
        this.resolveIndicesAndAnalyze(parsed, configuration, executionInfo, description, requestFilter, preAnalysis, result, logicalPlanListener);
    }

    private void resolveIndicesAndAnalyze(LogicalPlan parsed, Configuration configuration, EsqlExecutionInfo executionInfo, String description, QueryBuilder requestFilter, PreAnalyzer.PreAnalysis preAnalysis, PreAnalysisResult result, ActionListener<Versioned<LogicalPlan>> logicalPlanListener) {
        SubscribableListener.newForked(l -> this.preAnalyzeMainIndices(preAnalysis, executionInfo, result, requestFilter, (ActionListener<PreAnalysisResult>)l)).andThenApply(r -> {
            if (!r.indexResolution.isEmpty() && executionInfo.isCrossClusterSearch() && executionInfo.getRunningClusterAliases().findAny().isEmpty()) {
                LOGGER.debug("No more clusters to search, ending analysis stage");
                throw new NoClustersToSearchException();
            }
            return r;
        }).andThen((l, r) -> this.preAnalyzeLookupIndices(preAnalysis.lookupIndices().iterator(), (PreAnalysisResult)r, executionInfo, (ActionListener<PreAnalysisResult>)l)).andThen((l, r) -> this.enrichPolicyResolver.resolvePolicies(preAnalysis.enriches(), executionInfo, (ActionListener<EnrichResolution>)l.map(r::withEnrichResolution))).andThen((l, r) -> this.inferenceService.inferenceResolver(this.functionRegistry).resolveInferenceIds(parsed, (ActionListener<InferenceResolution>)l.map(r::withInferenceResolution))).andThen((l, r) -> this.analyzeWithRetry(parsed, configuration, executionInfo, description, requestFilter, preAnalysis, (PreAnalysisResult)r, (ActionListener<Versioned<LogicalPlan>>)l)).addListener(logicalPlanListener);
    }

    private void preAnalyzeLookupIndices(Iterator<IndexPattern> lookupIndices, PreAnalysisResult preAnalysisResult, EsqlExecutionInfo executionInfo, ActionListener<PreAnalysisResult> listener) {
        EsqlSession.forAll(lookupIndices, preAnalysisResult, (lookupIndex, r, l) -> this.preAnalyzeLookupIndex((IndexPattern)lookupIndex, (PreAnalysisResult)r, executionInfo, (ActionListener<PreAnalysisResult>)l), listener);
    }

    private void preAnalyzeLookupIndex(IndexPattern lookupIndexPattern, PreAnalysisResult result, EsqlExecutionInfo executionInfo, ActionListener<PreAnalysisResult> listener) {
        String localPattern = lookupIndexPattern.indexPattern();
        assert (!RemoteClusterAware.isRemoteIndexName((String)localPattern)) : "Lookup index name should not include remote, but got: " + localPattern;
        assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"search", "search_coordination", "system_read"}));
        this.indexResolver.resolveIndices(EsqlCCSUtils.createQualifiedLookupIndexExpressionFromAvailableClusters(executionInfo, localPattern), result.wildcardJoinIndices().contains(localPattern) ? IndexResolver.ALL_FIELDS : result.fieldNames, null, false, false, false, (ActionListener<IndexResolution>)listener.map(indexResolution -> this.receiveLookupIndexResolution(result, localPattern, executionInfo, (IndexResolution)indexResolution)));
    }

    private void skipClusterOrError(String clusterAlias, EsqlExecutionInfo executionInfo, String message) {
        this.skipClusterOrError(clusterAlias, executionInfo, (ElasticsearchException)new VerificationException(message, new Object[0]));
    }

    private void skipClusterOrError(String clusterAlias, EsqlExecutionInfo executionInfo, ElasticsearchException error) {
        if (!executionInfo.shouldSkipOnFailure(clusterAlias)) {
            throw error;
        }
        EsqlCCSUtils.markClusterWithFinalStateAndNoShards(executionInfo, clusterAlias, EsqlExecutionInfo.Cluster.Status.SKIPPED, (Exception)error);
    }

    private PreAnalysisResult receiveLookupIndexResolution(PreAnalysisResult result, String index, EsqlExecutionInfo executionInfo, IndexResolution lookupIndexResolution) {
        EsqlCCSUtils.updateExecutionInfoWithUnavailableClusters(executionInfo, lookupIndexResolution.failures());
        if (!lookupIndexResolution.isValid()) {
            return result.addLookupIndexResolution(index, lookupIndexResolution);
        }
        if (executionInfo.getClusters().isEmpty() || !executionInfo.isCrossClusterSearch()) {
            if (lookupIndexResolution.get().indexNameWithModes().isEmpty()) {
                return result.addLookupIndexResolution(index, lookupIndexResolution);
            }
            if (lookupIndexResolution.get().indexNameWithModes().size() > 1) {
                throw new VerificationException("Lookup Join requires a single lookup mode index; [" + index + "] resolves to multiple indices", new Object[0]);
            }
            Map.Entry<String, IndexMode> indexModeEntry = lookupIndexResolution.get().indexNameWithModes().entrySet().iterator().next();
            if (indexModeEntry.getValue() != IndexMode.LOOKUP) {
                throw new VerificationException("Lookup Join requires a single lookup mode index; [" + index + "] resolves to [" + indexModeEntry.getKey() + "] in [" + String.valueOf(indexModeEntry.getValue()) + "] mode", new Object[0]);
            }
            return result.addLookupIndexResolution(index, lookupIndexResolution);
        }
        if (lookupIndexResolution.get().indexNameWithModes().isEmpty() && !lookupIndexResolution.resolvedIndices().isEmpty()) {
            return result.addLookupIndexResolution(index, lookupIndexResolution);
        }
        HashMap clustersWithResolvedIndices = new HashMap(lookupIndexResolution.resolvedIndices().size());
        lookupIndexResolution.get().indexNameWithModes().forEach((indexName, indexMode) -> {
            String clusterAlias = RemoteClusterAware.parseClusterAlias((String)indexName);
            if (indexMode != IndexMode.LOOKUP) {
                this.skipClusterOrError(clusterAlias, executionInfo, "Lookup Join requires a single lookup mode index; [" + index + "] resolves to [" + indexName + "] in [" + String.valueOf(indexMode) + "] mode");
            }
            if (clustersWithResolvedIndices.containsKey(clusterAlias)) {
                this.skipClusterOrError(clusterAlias, executionInfo, "Lookup Join requires a single lookup mode index; [" + index + "] resolves to multiple indices " + EsqlCCSUtils.inClusterName(clusterAlias));
            } else {
                clustersWithResolvedIndices.put(clusterAlias, indexName);
            }
        });
        executionInfo.getRunningClusterAliases().forEach(clusterAlias -> {
            if (!clustersWithResolvedIndices.containsKey(clusterAlias)) {
                this.skipClusterOrError((String)clusterAlias, executionInfo, this.findFailure(lookupIndexResolution.failures(), index, (String)clusterAlias));
            }
        });
        return result.addLookupIndexResolution(index, this.checkSingleIndex(index, executionInfo, lookupIndexResolution, clustersWithResolvedIndices.values()));
    }

    private ElasticsearchException findFailure(Map<String, List<FieldCapabilitiesFailure>> failures, String index, String clusterAlias) {
        Optional<Exception> exc;
        if (failures.containsKey(clusterAlias) && (exc = failures.get(clusterAlias).stream().findFirst().map(FieldCapabilitiesFailure::getException)).isPresent()) {
            return new VerificationException("lookup failed " + EsqlCCSUtils.inClusterName(clusterAlias) + " for index [" + index + "]", ExceptionsHelper.unwrapCause((Throwable)exc.get()));
        }
        return new VerificationException("lookup index [" + index + "] is not available " + EsqlCCSUtils.inClusterName(clusterAlias), new Object[0]);
    }

    private IndexResolution checkSingleIndex(String index, EsqlExecutionInfo executionInfo, IndexResolution lookupIndexResolution, Collection<String> indexNames) {
        Set localIndexNames = indexNames.stream().map(n -> RemoteClusterAware.splitIndexName((String)n)[1]).collect(Collectors.toSet());
        if (localIndexNames.size() == 1) {
            String indexName = (String)localIndexNames.iterator().next();
            EsIndex newIndex = new EsIndex(index, lookupIndexResolution.get().mapping(), Map.of(indexName, IndexMode.LOOKUP), Map.of(), Map.of(), Set.of());
            return IndexResolution.valid(newIndex, newIndex.concreteQualifiedIndices(), lookupIndexResolution.failures());
        }
        this.validateRemoteVersions(executionInfo);
        return lookupIndexResolution;
    }

    private void validateRemoteVersions(EsqlExecutionInfo executionInfo) {
        executionInfo.getRunningClusterAliases().forEach(clusterAlias -> {
            Transport.Connection connection;
            if (!clusterAlias.equals("") && (connection = this.remoteClusterService.getConnection(clusterAlias)) != null && !connection.getTransportVersion().supports(LOOKUP_JOIN_CCS)) {
                this.skipClusterOrError((String)clusterAlias, executionInfo, "remote cluster [" + clusterAlias + "] has version [" + String.valueOf(connection.getTransportVersion()) + "] that does not support multiple indices in LOOKUP JOIN, skipping");
            }
        });
    }

    private void preAnalyzeMainIndices(PreAnalyzer.PreAnalysis preAnalysis, EsqlExecutionInfo executionInfo, PreAnalysisResult result, QueryBuilder requestFilter, ActionListener<PreAnalysisResult> listener) {
        EsqlCCSUtils.initCrossClusterState(this.indicesExpressionGrouper, this.verifier.licenseState(), preAnalysis.indexes().keySet(), executionInfo);
        EsqlSession.forAll(preAnalysis.indexes().entrySet().iterator(), result, (entry, r, l) -> this.preAnalyzeMainIndices((IndexPattern)entry.getKey(), (IndexMode)entry.getValue(), preAnalysis, executionInfo, (PreAnalysisResult)r, requestFilter, (ActionListener<PreAnalysisResult>)l), listener);
    }

    private void preAnalyzeMainIndices(IndexPattern indexPattern, IndexMode indexMode, PreAnalyzer.PreAnalysis preAnalysis, EsqlExecutionInfo executionInfo, PreAnalysisResult result, QueryBuilder requestFilter, ActionListener<PreAnalysisResult> listener) {
        assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"search", "search_coordination", "system_read"}));
        if (executionInfo.clusterAliases().isEmpty()) {
            listener.onResponse((Object)result.withIndices(indexPattern, IndexResolution.empty(indexPattern.indexPattern())));
        } else {
            String string = indexPattern.indexPattern();
            Set<String> set = result.fieldNames;
            this.indexResolver.resolveIndicesVersioned(string, set, switch (indexMode) {
                case IndexMode.TIME_SERIES -> {
                    TermQueryBuilder indexModeFilter = new TermQueryBuilder("_index_mode", IndexMode.TIME_SERIES.getName());
                    if (requestFilter != null) {
                        yield new BoolQueryBuilder().filter(requestFilter).filter((QueryBuilder)indexModeFilter);
                    }
                    yield indexModeFilter;
                }
                default -> requestFilter;
            }, indexMode == IndexMode.TIME_SERIES, preAnalysis.useAggregateMetricDoubleWhenNotSupported(), preAnalysis.useDenseVectorWhenNotSupported(), this.indicesExpressionGrouper, (ActionListener<Versioned<IndexResolution>>)listener.delegateFailureAndWrap((l, indexResolution) -> {
                EsqlCCSUtils.updateExecutionInfoWithUnavailableClusters(executionInfo, ((IndexResolution)indexResolution.inner()).failures());
                l.onResponse((Object)result.withIndices(indexPattern, (IndexResolution)indexResolution.inner()).withMinimumTransportVersion(indexResolution.minimumVersion()));
            }));
        }
    }

    private void analyzeWithRetry(LogicalPlan parsed, Configuration configuration, EsqlExecutionInfo executionInfo, String description, QueryBuilder requestFilter, PreAnalyzer.PreAnalysis preAnalysis, PreAnalysisResult result, ActionListener<Versioned<LogicalPlan>> listener) {
        LOGGER.debug("Analyzing the plan ({})", new Object[]{description});
        try {
            if (result.indexResolution.values().stream().anyMatch(IndexResolution::isValid) || requestFilter != null) {
                EsqlCCSUtils.updateExecutionInfoWithClustersWithNoMatchingIndices(executionInfo, result.indexResolution.values(), requestFilter != null);
            }
            LogicalPlan plan = this.analyzedPlan(parsed, configuration, result, executionInfo);
            LOGGER.debug("Analyzed plan ({}):\n{}", new Object[]{description, plan});
            listener.onResponse(new Versioned<LogicalPlan>(plan, result.minimumTransportVersion()));
        }
        catch (VerificationException ve) {
            LOGGER.debug("Analyzing the plan ({}) failed with {}", new Object[]{description, ve.getDetailedMessage()});
            if (requestFilter == null) {
                listener.onFailure((Exception)((Object)ve));
            } else {
                executionInfo.clusterInfo.clear();
                this.resolveIndicesAndAnalyze(parsed, configuration, executionInfo, "second attempt, without filter", null, preAnalysis, result, listener);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private PhysicalPlan logicalPlanToPhysicalPlan(LogicalPlan optimizedPlan, EsqlQueryRequest request, PhysicalPlanOptimizer physicalPlanOptimizer) {
        PhysicalPlan physicalPlan = this.optimizedPhysicalPlan(optimizedPlan, physicalPlanOptimizer);
        physicalPlan = (PhysicalPlan)physicalPlan.transformUp(FragmentExec.class, f -> {
            QueryBuilder filter = request.filter();
            if (filter != null) {
                QueryBuilder fragmentFilter = f.esFilter();
                filter = fragmentFilter != null ? QueryBuilders.boolQuery().filter(fragmentFilter).must(filter) : filter;
                LOGGER.debug("Fold filter {} to EsQueryExec", new Object[]{filter});
                f = f.withFilter(filter);
            }
            return f;
        });
        return EstimatesRowSize.estimateRowSize(0, physicalPlan);
    }

    private LogicalPlan analyzedPlan(LogicalPlan parsed, Configuration configuration, PreAnalysisResult r, EsqlExecutionInfo executionInfo) throws Exception {
        EsqlSession.handleFieldCapsFailures(configuration.allowPartialResults(), executionInfo, r.indexResolution());
        Analyzer analyzer = new Analyzer(new AnalyzerContext(configuration, this.functionRegistry, r), this.verifier);
        LogicalPlan plan = analyzer.analyze(parsed);
        plan.setAnalyzed();
        return plan;
    }

    public LogicalPlan optimizedPlan(LogicalPlan logicalPlan, LogicalPlanOptimizer logicalPlanOptimizer) {
        if (!logicalPlan.preOptimized()) {
            throw new IllegalStateException("Expected pre-optimized plan");
        }
        LogicalPlan plan = logicalPlanOptimizer.optimize(logicalPlan);
        LOGGER.debug("Optimized logicalPlan plan:\n{}", new Object[]{plan});
        return plan;
    }

    public void preOptimizedPlan(LogicalPlan logicalPlan, LogicalPlanPreOptimizer logicalPlanPreOptimizer, ActionListener<LogicalPlan> listener) {
        logicalPlanPreOptimizer.preOptimize(logicalPlan, listener);
    }

    private PhysicalPlan physicalPlan(Versioned<LogicalPlan> optimizedPlan) {
        LogicalPlan logicalPlan = optimizedPlan.inner();
        if (!logicalPlan.optimized()) {
            throw new IllegalStateException("Expected optimized plan");
        }
        this.optimizedLogicalPlanString = logicalPlan.toString();
        PhysicalPlan plan = this.mapper.map(optimizedPlan);
        LOGGER.debug("Physical plan:\n{}", new Object[]{plan});
        return plan;
    }

    private PhysicalPlan optimizedPhysicalPlan(LogicalPlan optimizedPlan, PhysicalPlanOptimizer physicalPlanOptimizer) {
        PhysicalPlan plan = physicalPlanOptimizer.optimize(this.physicalPlan(new Versioned<LogicalPlan>(optimizedPlan, ((PhysicalOptimizerContext)physicalPlanOptimizer.context()).minimumVersion())));
        LOGGER.debug("Optimized physical plan:\n{}", new Object[]{plan});
        return plan;
    }

    private static <T> void forAll(Iterator<T> iterator, PreAnalysisResult result, TriConsumer<T, PreAnalysisResult, ActionListener<PreAnalysisResult>> consumer, ActionListener<PreAnalysisResult> listener) {
        if (iterator.hasNext()) {
            consumer.apply(iterator.next(), (Object)result, (Object)listener.delegateFailureAndWrap((l, r) -> EsqlSession.forAll(iterator, r, consumer, (ActionListener<PreAnalysisResult>)l)));
        } else {
            listener.onResponse((Object)result);
        }
    }

    public static interface PlanRunner {
        public void run(PhysicalPlan var1, Configuration var2, FoldContext var3, ActionListener<Result> var4);
    }

    public record PreAnalysisResult(Set<String> fieldNames, Set<String> wildcardJoinIndices, Map<IndexPattern, IndexResolution> indexResolution, Map<String, IndexResolution> lookupIndices, EnrichResolution enrichResolution, InferenceResolution inferenceResolution, TransportVersion minimumTransportVersion) {
        public PreAnalysisResult(Set<String> fieldNames, Set<String> wildcardJoinIndices) {
            this(fieldNames, wildcardJoinIndices, new HashMap<IndexPattern, IndexResolution>(), new HashMap<String, IndexResolution>(), null, InferenceResolution.EMPTY, TransportVersion.current());
        }

        PreAnalysisResult withIndices(IndexPattern indexPattern, IndexResolution indices) {
            this.indexResolution.put(indexPattern, indices);
            return this;
        }

        PreAnalysisResult addLookupIndexResolution(String index, IndexResolution indexResolution) {
            this.lookupIndices.put(index, indexResolution);
            return this;
        }

        PreAnalysisResult withEnrichResolution(EnrichResolution enrichResolution) {
            return new PreAnalysisResult(this.fieldNames, this.wildcardJoinIndices, this.indexResolution, this.lookupIndices, enrichResolution, this.inferenceResolution, this.minimumTransportVersion);
        }

        PreAnalysisResult withInferenceResolution(InferenceResolution inferenceResolution) {
            return new PreAnalysisResult(this.fieldNames, this.wildcardJoinIndices, this.indexResolution, this.lookupIndices, this.enrichResolution, inferenceResolution, this.minimumTransportVersion);
        }

        PreAnalysisResult withMinimumTransportVersion(TransportVersion minimumTransportVersion) {
            if (this.minimumTransportVersion != null) {
                if (this.minimumTransportVersion.equals((Object)minimumTransportVersion)) {
                    return this;
                }
                minimumTransportVersion = TransportVersion.min((TransportVersion)this.minimumTransportVersion, (TransportVersion)minimumTransportVersion);
            }
            return new PreAnalysisResult(this.fieldNames, this.wildcardJoinIndices, this.indexResolution, this.lookupIndices, this.enrichResolution, this.inferenceResolution, minimumTransportVersion);
        }
    }
}

