/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Abs;

public final class AbsLongEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(AbsLongEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator fieldVal;
    private final DriverContext driverContext;
    private Warnings warnings;

    public AbsLongEvaluator(Source source, EvalOperator.ExpressionEvaluator fieldVal, DriverContext driverContext) {
        this.source = source;
        this.fieldVal = fieldVal;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock fieldValBlock = (LongBlock)this.fieldVal.eval(page);){
            LongVector fieldValVector = fieldValBlock.asVector();
            if (fieldValVector == null) {
                LongBlock longBlock = this.eval(page.getPositionCount(), fieldValBlock);
                return longBlock;
            }
            LongBlock longBlock = this.eval(page.getPositionCount(), fieldValVector).asBlock();
            return longBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.fieldVal.baseRamBytesUsed();
    }

    public LongBlock eval(int positionCount, LongBlock fieldValBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            block9: for (int p = 0; p < positionCount; ++p) {
                switch (fieldValBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block9;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block9;
                    }
                }
                long fieldVal = fieldValBlock.getLong(fieldValBlock.getFirstValueIndex(p));
                result.appendLong(Abs.process(fieldVal));
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongVector eval(int positionCount, LongVector fieldValVector) {
        try (LongVector.FixedBuilder result = this.driverContext.blockFactory().newLongVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                long fieldVal = fieldValVector.getLong(p);
                result.appendLong(p, Abs.process(fieldVal));
            }
            LongVector longVector = result.build();
            return longVector;
        }
    }

    public String toString() {
        return "AbsLongEvaluator[fieldVal=" + String.valueOf(this.fieldVal) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.fieldVal);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory fieldVal;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory fieldVal) {
            this.source = source;
            this.fieldVal = fieldVal;
        }

        public AbsLongEvaluator get(DriverContext context) {
            return new AbsLongEvaluator(this.source, this.fieldVal.get(context), context);
        }

        public String toString() {
            return "AbsLongEvaluator[fieldVal=" + String.valueOf(this.fieldVal) + "]";
        }
    }
}

