/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.util.Objects;
import java.util.concurrent.atomic.LongAccumulator;
import org.apache.lucene.search.knn.KnnSearchStrategy;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.search.vectors.AbstractMaxScoreKnnCollector;

public class IVFKnnSearchStrategy
extends KnnSearchStrategy {
    private final float visitRatio;
    private final SetOnce<AbstractMaxScoreKnnCollector> collector = new SetOnce();
    private final LongAccumulator accumulator;

    public IVFKnnSearchStrategy(float visitRatio, LongAccumulator accumulator) {
        this.visitRatio = visitRatio;
        this.accumulator = accumulator;
    }

    void setCollector(AbstractMaxScoreKnnCollector collector) {
        this.collector.set((Object)collector);
        if (this.accumulator != null) {
            collector.updateMinCompetitiveDocScore(this.accumulator.get());
        }
    }

    public float getVisitRatio() {
        return this.visitRatio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IVFKnnSearchStrategy that = (IVFKnnSearchStrategy)((Object)o);
        return this.visitRatio == that.visitRatio;
    }

    public int hashCode() {
        return Objects.hashCode(Float.valueOf(this.visitRatio));
    }

    public void nextVectorsBlock() {
        if (this.accumulator == null) {
            return;
        }
        assert (this.collector.get() != null) : "Collector must be set before nextVectorsBlock is called";
        AbstractMaxScoreKnnCollector knnCollector = (AbstractMaxScoreKnnCollector)((Object)this.collector.get());
        long collectorScore = knnCollector.getMinCompetitiveDocScore();
        this.accumulator.accumulate(collectorScore);
        long currentScore = this.accumulator.get();
        if (currentScore > collectorScore) {
            knnCollector.updateMinCompetitiveDocScore(currentScore);
        }
    }
}

