/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.action.admin.indices.shrink.TransportResizeAction;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;

public abstract class RestResizeHandler
extends BaseRestHandler {
    RestResizeHandler() {
    }

    @Override
    public abstract String getName();

    abstract ResizeType getResizeType();

    @Override
    public final BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ResizeRequest resizeRequest = new ResizeRequest(RestUtils.getMasterNodeTimeout(request), RestUtils.getAckTimeout(request), this.getResizeType(), request.param("index"), request.param("target"));
        request.applyContentParser((CheckedConsumer<XContentParser, IOException>)((CheckedConsumer)resizeRequest::fromXContent));
        resizeRequest.setWaitForActiveShards(ActiveShardCount.parseString(request.param("wait_for_active_shards")));
        return channel -> client.execute(TransportResizeAction.TYPE, resizeRequest, new RestToXContentListener((RestChannel)channel));
    }

    public static class RestCloneIndexAction
    extends RestResizeHandler {
        @Override
        public List<RestHandler.Route> routes() {
            return List.of(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_clone/{target}"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_clone/{target}"));
        }

        @Override
        public String getName() {
            return "clone_index_action";
        }

        @Override
        protected ResizeType getResizeType() {
            return ResizeType.CLONE;
        }
    }

    public static class RestSplitIndexAction
    extends RestResizeHandler {
        @Override
        public List<RestHandler.Route> routes() {
            return List.of(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_split/{target}"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_split/{target}"));
        }

        @Override
        public String getName() {
            return "split_index_action";
        }

        @Override
        protected ResizeType getResizeType() {
            return ResizeType.SPLIT;
        }
    }

    public static class RestShrinkIndexAction
    extends RestResizeHandler {
        @Override
        public List<RestHandler.Route> routes() {
            return List.of(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_shrink/{target}"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_shrink/{target}"));
        }

        @Override
        public String getName() {
            return "shrink_index_action";
        }

        @Override
        protected ResizeType getResizeType() {
            return ResizeType.SHRINK;
        }
    }
}

