/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;
import org.elasticsearch.script.BooleanFieldScript;

public class BooleanScriptBlockDocValuesReader
extends BlockDocValuesReader {
    private final BooleanFieldScript script;
    private int docId;

    BooleanScriptBlockDocValuesReader(BooleanFieldScript script) {
        this.script = script;
    }

    @Override
    public int docId() {
        return this.docId;
    }

    @Override
    public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
        try (BlockLoader.BooleanBuilder builder = factory.booleans(docs.count() - offset);){
            for (int i = offset; i < docs.count(); ++i) {
                this.read(docs.get(i), builder);
            }
            BlockLoader.Block block = builder.build();
            return block;
        }
    }

    @Override
    public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
        this.docId = docId;
        this.read(docId, (BlockLoader.BooleanBuilder)builder);
    }

    private void read(int docId, BlockLoader.BooleanBuilder builder) {
        this.script.runForDoc(docId);
        int total = this.script.falses() + this.script.trues();
        switch (total) {
            case 0: {
                builder.appendNull();
                break;
            }
            case 1: {
                builder.appendBoolean(this.script.trues() > 0);
                break;
            }
            default: {
                int i;
                builder.beginPositionEntry();
                for (i = 0; i < this.script.falses(); ++i) {
                    builder.appendBoolean(false);
                }
                for (i = 0; i < this.script.trues(); ++i) {
                    builder.appendBoolean(true);
                }
                builder.endPositionEntry();
            }
        }
    }

    @Override
    public String toString() {
        return "ScriptBooleans";
    }

    static class BooleanScriptBlockLoader
    extends BlockDocValuesReader.DocValuesBlockLoader {
        private final BooleanFieldScript.LeafFactory factory;

        BooleanScriptBlockLoader(BooleanFieldScript.LeafFactory factory) {
            this.factory = factory;
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.booleans(expectedCount);
        }

        @Override
        public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
            return new BooleanScriptBlockDocValuesReader(this.factory.newInstance(context));
        }
    }
}

