/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.promql;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.expression.function.Function;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.promql.function.PromqlFunctionRegistry;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.SurrogateLogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.TimeSeriesAggregate;
import org.elasticsearch.xpack.esql.plan.logical.promql.PromqlFunctionCall;

public class WithinSeriesAggregate
extends PromqlFunctionCall
implements SurrogateLogicalPlan {
    public WithinSeriesAggregate(Source source, LogicalPlan child, String functionName, List<Expression> parameters) {
        super(source, child, functionName, parameters);
    }

    @Override
    protected NodeInfo<PromqlFunctionCall> info() {
        return NodeInfo.create((Node)this, WithinSeriesAggregate::new, (Object)((Object)this.child()), (Object)this.functionName(), this.parameters());
    }

    @Override
    public WithinSeriesAggregate replaceChild(LogicalPlan newChild) {
        return new WithinSeriesAggregate(this.source(), newChild, this.functionName(), this.parameters());
    }

    @Override
    public LogicalPlan surrogate() {
        LogicalPlan childPlan = this.child();
        ReferenceAttribute timestampField = new ReferenceAttribute(this.source(), "@timestamp", DataType.DATETIME);
        ReferenceAttribute valueField = new ReferenceAttribute(this.source(), "value", DataType.DOUBLE);
        ReferenceAttribute tsidField = new ReferenceAttribute(this.source(), "_tsid", DataType.KEYWORD);
        ArrayList<Expression> functionParams = new ArrayList<Expression>();
        functionParams.add((Expression)valueField);
        functionParams.add((Expression)timestampField);
        functionParams.addAll(this.parameters());
        Function esqlFunction = PromqlFunctionRegistry.INSTANCE.buildEsqlFunction(this.functionName(), this.source(), functionParams);
        String internalName = this.functionName() + "_$result";
        Alias functionAlias = new Alias(this.source(), internalName, (Expression)esqlFunction);
        ArrayList<Expression> groupings = new ArrayList<Expression>();
        groupings.add((Expression)tsidField);
        ArrayList<Object> aggregates = new ArrayList<Object>();
        aggregates.add(functionAlias);
        aggregates.add(tsidField);
        return new TimeSeriesAggregate(this.source(), childPlan, groupings, aggregates, null);
    }
}

