/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.inference;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisVerificationAware;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.inference.InferencePlan;

public class Rerank
extends InferencePlan<Rerank>
implements PostAnalysisVerificationAware,
TelemetryAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "Rerank", Rerank::new);
    public static final String DEFAULT_INFERENCE_ID = ".rerank-v1-elasticsearch";
    private final Attribute scoreAttribute;
    private final Expression queryText;
    private final List<Alias> rerankFields;
    private List<Attribute> lazyOutput;

    public Rerank(Source source, LogicalPlan child, Expression queryText, List<Alias> rerankFields, Attribute scoreAttribute) {
        this(source, child, (Expression)Literal.keyword((Source)Source.EMPTY, (String)DEFAULT_INFERENCE_ID), queryText, rerankFields, scoreAttribute);
    }

    public Rerank(Source source, LogicalPlan child, Expression inferenceId, Expression queryText, List<Alias> rerankFields, Attribute scoreAttribute) {
        super(source, child, inferenceId);
        this.queryText = queryText;
        this.rerankFields = rerankFields;
        this.scoreAttribute = scoreAttribute;
    }

    public Rerank(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (LogicalPlan)in.readNamedWriteable(LogicalPlan.class), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), in.readCollectionAsList(Alias::new), (Attribute)in.readNamedWriteable(Attribute.class));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.queryText);
        out.writeCollection(this.rerankFields());
        out.writeNamedWriteable((NamedWriteable)this.scoreAttribute);
    }

    public Expression queryText() {
        return this.queryText;
    }

    public List<Alias> rerankFields() {
        return this.rerankFields;
    }

    public Attribute scoreAttribute() {
        return this.scoreAttribute;
    }

    @Override
    public TaskType taskType() {
        return TaskType.RERANK;
    }

    @Override
    public Rerank withInferenceId(Expression newInferenceId) {
        if (this.inferenceId().equals((Object)newInferenceId)) {
            return this;
        }
        return new Rerank(this.source(), this.child(), newInferenceId, this.queryText, this.rerankFields, this.scoreAttribute);
    }

    public Rerank withRerankFields(List<Alias> newRerankFields) {
        if (this.rerankFields.equals(newRerankFields)) {
            return this;
        }
        return new Rerank(this.source(), this.child(), this.inferenceId(), this.queryText, newRerankFields, this.scoreAttribute);
    }

    public Rerank withScoreAttribute(Attribute newScoreAttribute) {
        if (this.scoreAttribute.equals((Object)newScoreAttribute)) {
            return this;
        }
        return new Rerank(this.source(), this.child(), this.inferenceId(), this.queryText, this.rerankFields, newScoreAttribute);
    }

    public String getWriteableName() {
        return Rerank.ENTRY.name;
    }

    @Override
    public UnaryPlan replaceChild(LogicalPlan newChild) {
        return new Rerank(this.source(), newChild, this.inferenceId(), this.queryText, this.rerankFields, this.scoreAttribute);
    }

    @Override
    protected AttributeSet computeReferences() {
        return Rerank.computeReferences(this.rerankFields);
    }

    @Override
    public List<Attribute> generatedAttributes() {
        return List.of(this.scoreAttribute);
    }

    @Override
    public Rerank withGeneratedNames(List<String> newNames) {
        this.checkNumberOfNewNames(newNames);
        return new Rerank(this.source(), this.child(), this.inferenceId(), this.queryText, this.rerankFields, this.renameScoreAttribute(newNames.get(0)));
    }

    private Attribute renameScoreAttribute(String newName) {
        if (newName.equals(this.scoreAttribute.name())) {
            return this.scoreAttribute;
        }
        return this.scoreAttribute.withName(newName).withId(new NameId());
    }

    public static AttributeSet computeReferences(List<Alias> fields) {
        return Eval.computeReferences(fields);
    }

    public boolean isValidRerankField(Alias rerankField) {
        return DataType.isString((DataType)rerankField.dataType()) || rerankField.dataType() == DataType.BOOLEAN || rerankField.dataType().isNumeric();
    }

    @Override
    public boolean expressionsResolved() {
        return super.expressionsResolved() && this.queryText.resolved() && Resolvables.resolved(this.rerankFields) && this.scoreAttribute.resolved();
    }

    @Override
    public boolean isFoldable() {
        return false;
    }

    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create((Node)this, Rerank::new, (Object)((Object)this.child()), (Object)this.inferenceId(), (Object)this.queryText, this.rerankFields, (Object)this.scoreAttribute);
    }

    @Override
    public void postAnalysisVerification(Failures failures) {
        if (this.queryText.resolved()) {
            if (!DataType.isString((DataType)this.queryText.dataType())) {
                failures.add(Failure.fail(this.queryText, "query must be a valid string in RERANK, found [{}]", new Object[]{this.queryText.source().text()}));
            }
            if (!this.queryText.foldable()) {
                failures.add(Failure.fail(this.queryText, "query must be a constant, found [{}]", new Object[]{this.queryText.source().text()}));
            }
        }
        this.rerankFields.stream().filter(Predicate.not(this::isValidRerankField)).forEach(rerankField -> failures.add(Failure.fail(rerankField, "rerank field must be a valid string, numeric or boolean expression, found [{}]", new Object[]{rerankField.source().text()})));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Rerank rerank = (Rerank)o;
        return Objects.equals(this.queryText, rerank.queryText) && Objects.equals(this.rerankFields, rerank.rerankFields) && Objects.equals(this.scoreAttribute, rerank.scoreAttribute);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.queryText, this.rerankFields, this.scoreAttribute);
    }

    @Override
    public List<Attribute> output() {
        if (this.lazyOutput == null) {
            this.lazyOutput = NamedExpressions.mergeOutputAttributes(List.of(this.scoreAttribute), this.child().output());
        }
        return this.lazyOutput;
    }
}

