/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical.promql;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.action.PromqlFeatures;
import org.elasticsearch.xpack.esql.capabilities.ConfigurationAware;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.function.Function;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.RLikePattern;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.Order;
import org.elasticsearch.xpack.esql.expression.function.grouping.Bucket;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.EndsWith;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.StartsWith;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.regex.RLike;
import org.elasticsearch.xpack.esql.expression.predicate.Predicates;
import org.elasticsearch.xpack.esql.expression.predicate.logical.And;
import org.elasticsearch.xpack.esql.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.In;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.esql.expression.promql.function.PromqlFunctionRegistry;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.promql.AutomatonUtils;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.plan.logical.TimeSeriesAggregate;
import org.elasticsearch.xpack.esql.plan.logical.promql.AcrossSeriesAggregate;
import org.elasticsearch.xpack.esql.plan.logical.promql.PlaceholderRelation;
import org.elasticsearch.xpack.esql.plan.logical.promql.PromqlCommand;
import org.elasticsearch.xpack.esql.plan.logical.promql.PromqlFunctionCall;
import org.elasticsearch.xpack.esql.plan.logical.promql.WithinSeriesAggregate;
import org.elasticsearch.xpack.esql.plan.logical.promql.selector.LabelMatcher;
import org.elasticsearch.xpack.esql.plan.logical.promql.selector.LabelMatchers;
import org.elasticsearch.xpack.esql.plan.logical.promql.selector.Selector;

public final class TranslatePromqlToTimeSeriesAggregate
extends OptimizerRules.OptimizerRule<PromqlCommand> {
    public static final Duration DEFAULT_LOOKBACK = Duration.ofMinutes(5L);

    public TranslatePromqlToTimeSeriesAggregate() {
        super(OptimizerRules.TransformDirection.UP);
    }

    @Override
    protected LogicalPlan rule(PromqlCommand promqlCommand) {
        if (!PromqlFeatures.isEnabled()) {
            throw new EsqlIllegalArgumentException("PromQL translation attempted but feature is disabled. This should have been caught by the parser.");
        }
        LogicalPlan promqlPlan = promqlCommand.promqlPlan();
        promqlPlan = (LogicalPlan)promqlPlan.transformUp(PlaceholderRelation.class, pr -> TranslatePromqlToTimeSeriesAggregate.withTimestampFilter(promqlCommand, promqlCommand.child()));
        return TranslatePromqlToTimeSeriesAggregate.map(promqlCommand, promqlPlan).plan();
    }

    private static LogicalPlan withTimestampFilter(PromqlCommand promqlCommand, LogicalPlan plan) {
        if (promqlCommand.start().value() != null && promqlCommand.end().value() != null) {
            Source promqlSource = promqlCommand.source();
            Expression timestamp = promqlCommand.timestamp();
            plan = new Filter(promqlSource, plan, (Expression)new And(promqlSource, (Expression)new GreaterThanOrEqual(promqlSource, timestamp, (Expression)promqlCommand.start()), (Expression)new LessThanOrEqual(promqlSource, timestamp, (Expression)promqlCommand.end())));
        }
        return plan;
    }

    private static MapResult map(PromqlCommand promqlCommand, LogicalPlan p) {
        if (p instanceof Selector) {
            Selector selector = (Selector)p;
            return TranslatePromqlToTimeSeriesAggregate.map(promqlCommand, selector);
        }
        if (p instanceof PromqlFunctionCall) {
            PromqlFunctionCall functionCall = (PromqlFunctionCall)p;
            return TranslatePromqlToTimeSeriesAggregate.map(promqlCommand, functionCall);
        }
        throw new QlIllegalArgumentException("Unsupported PromQL plan node: {}", new Object[]{p});
    }

    private static MapResult map(PromqlCommand promqlCommand, Selector selector) {
        LabelMatchers matchers = selector.labelMatchers();
        Expression matcherCondition = TranslatePromqlToTimeSeriesAggregate.translateLabelMatchers(selector.source(), selector.labels(), matchers);
        ArrayList<Expression> selectorConditions = new ArrayList<Expression>();
        selectorConditions.add((Expression)new IsNotNull(selector.source(), selector.series()));
        if (matcherCondition != null) {
            selectorConditions.add(matcherCondition);
        }
        HashMap<String, Expression> extras = new HashMap<String, Expression>();
        extras.put("field", selector.series());
        Filter p = new Filter(selector.source(), selector.child(), Predicates.combineAnd(selectorConditions));
        return new MapResult(p, extras);
    }

    private static MapResult map(PromqlCommand promqlCommand, PromqlFunctionCall functionCall) {
        MapResult result;
        MapResult childResult = TranslatePromqlToTimeSeriesAggregate.map(promqlCommand, functionCall.child());
        Map<String, Expression> extras = childResult.extras;
        Expression target = extras.get("field");
        if (functionCall instanceof WithinSeriesAggregate) {
            WithinSeriesAggregate withinAggregate = (WithinSeriesAggregate)functionCall;
            Function esqlFunction = PromqlFunctionRegistry.INSTANCE.buildEsqlFunction(withinAggregate.functionName(), withinAggregate.source(), List.of(target, promqlCommand.timestamp()));
            extras.put("field", (Expression)esqlFunction);
            result = new MapResult(childResult.plan, extras);
        } else if (functionCall instanceof AcrossSeriesAggregate) {
            AcrossSeriesAggregate acrossAggregate = (AcrossSeriesAggregate)functionCall;
            Function esqlFunction = PromqlFunctionRegistry.INSTANCE.buildEsqlFunction(acrossAggregate.functionName(), acrossAggregate.source(), List.of(target));
            ArrayList<Object> aggs = new ArrayList<Object>();
            aggs.add(new Alias(acrossAggregate.source(), acrossAggregate.sourceText(), (Expression)esqlFunction));
            ArrayList<Expression> groupings = new ArrayList<Expression>(acrossAggregate.groupings().size());
            for (Expression grouping : acrossAggregate.groupings()) {
                NamedExpression ne;
                Object named = grouping instanceof NamedExpression ? (ne = (NamedExpression)grouping) : new Alias(grouping.source(), grouping.sourceText(), grouping);
                aggs.add(named);
                groupings.add((Expression)named.toAttribute());
            }
            Literal timeBucketSize = promqlCommand.isRangeQuery() ? promqlCommand.step() : Literal.timeDuration((Source)promqlCommand.source(), (Duration)DEFAULT_LOOKBACK);
            Bucket b = new Bucket(promqlCommand.source(), promqlCommand.timestamp(), (Expression)timeBucketSize, null, null, ConfigurationAware.CONFIGURATION_MARKER);
            String bucketName = "TBUCKET";
            Alias tbucket = new Alias(b.source(), bucketName, (Expression)b);
            aggs.add(tbucket.toAttribute());
            groupings.add((Expression)tbucket.toAttribute());
            LogicalPlan p = childResult.plan;
            p = new Eval(tbucket.source(), p, List.of(tbucket));
            p = new TimeSeriesAggregate(acrossAggregate.source(), p, groupings, aggs, null);
            p = new OrderBy(acrossAggregate.source(), p, Arrays.asList(new Order(acrossAggregate.source(), (Expression)tbucket.toAttribute(), Order.OrderDirection.ASC, Order.NullsPosition.FIRST)));
            result = new MapResult(p, extras);
        } else {
            throw new QlIllegalArgumentException("Unsupported PromQL function call: {}", new Object[]{functionCall});
        }
        return result;
    }

    static Expression translateLabelMatchers(Source source, List<Expression> fields, LabelMatchers labelMatchers) {
        ArrayList<Expression> conditions = new ArrayList<Expression>();
        boolean hasNameMatcher = false;
        List<LabelMatcher> matchers = labelMatchers.matchers();
        int s = matchers.size();
        for (int i = 0; i < s; ++i) {
            LabelMatcher matcher = matchers.get(i);
            if ("__name__".equals(matcher.name())) {
                hasNameMatcher = true;
                continue;
            }
            Expression field = fields.get(hasNameMatcher ? i - 1 : i);
            Expression condition = TranslatePromqlToTimeSeriesAggregate.translateLabelMatcher(source, field, matcher);
            if (condition == null) continue;
            conditions.add(condition);
        }
        if (conditions.isEmpty()) {
            return null;
        }
        return Predicates.combineAnd(conditions);
    }

    private static Expression translateLabelMatcher(Source source, Expression field, LabelMatcher matcher) {
        if (matcher.matchesAll()) {
            return Literal.fromBoolean((Source)source, (Boolean)true);
        }
        if (matcher.matchesNone()) {
            return Literal.fromBoolean((Source)source, (Boolean)false);
        }
        String exactMatch = AutomatonUtils.matchesExact(matcher.automaton());
        if (exactMatch != null) {
            return new Equals(source, field, (Expression)Literal.keyword((Source)source, (String)exactMatch));
        }
        List<AutomatonUtils.PatternFragment> fragments = AutomatonUtils.extractFragments(matcher.value());
        if (fragments != null && !fragments.isEmpty()) {
            return TranslatePromqlToTimeSeriesAggregate.translateDisjointPatterns(source, field, fragments);
        }
        return new RLike(source, field, new RLikePattern(matcher.toString()));
    }

    private static Expression translateDisjointPatterns(Source source, Expression field, List<AutomatonUtils.PatternFragment> fragments) {
        ArrayList<AutomatonUtils.PatternFragment> sortedFragments = new ArrayList<AutomatonUtils.PatternFragment>(fragments);
        sortedFragments.sort(Comparator.comparingInt(a -> a.type().ordinal()));
        AutomatonUtils.PatternFragment.Type firstType = ((AutomatonUtils.PatternFragment)sortedFragments.get(0)).type();
        boolean homogeneous = true;
        for (AutomatonUtils.PatternFragment fragment : sortedFragments) {
            if (fragment.type() == firstType) continue;
            homogeneous = false;
            break;
        }
        if (homogeneous && firstType == AutomatonUtils.PatternFragment.Type.EXACT) {
            ArrayList<Expression> values = new ArrayList<Expression>(sortedFragments.size());
            for (AutomatonUtils.PatternFragment fragment : sortedFragments) {
                values.add((Expression)Literal.keyword((Source)source, (String)fragment.value()));
            }
            return new In(source, field, values);
        }
        ArrayList<Expression> conditions = new ArrayList<Expression>(sortedFragments.size());
        for (AutomatonUtils.PatternFragment fragment : sortedFragments) {
            Expression condition = TranslatePromqlToTimeSeriesAggregate.translatePatternFragment(source, field, fragment);
            conditions.add(condition);
        }
        return Predicates.combineOr(conditions);
    }

    private static Expression translatePatternFragment(Source source, Expression field, AutomatonUtils.PatternFragment fragment) {
        Literal value = Literal.keyword((Source)source, (String)fragment.value());
        return switch (fragment.type()) {
            default -> throw new MatchException(null, null);
            case AutomatonUtils.PatternFragment.Type.EXACT -> new Equals(source, field, (Expression)value);
            case AutomatonUtils.PatternFragment.Type.PREFIX -> new StartsWith(source, field, (Expression)value);
            case AutomatonUtils.PatternFragment.Type.PROPER_PREFIX -> new And(source, (Expression)new NotEquals(source, field, (Expression)value), (Expression)new StartsWith(source, field, (Expression)value));
            case AutomatonUtils.PatternFragment.Type.SUFFIX -> new EndsWith(source, field, (Expression)value);
            case AutomatonUtils.PatternFragment.Type.PROPER_SUFFIX -> new And(source, (Expression)new NotEquals(source, field, (Expression)value), (Expression)new EndsWith(source, field, (Expression)value));
            case AutomatonUtils.PatternFragment.Type.REGEX -> new RLike(source, field, new RLikePattern(fragment.value()));
        };
    }

    private record MapResult(LogicalPlan plan, Map<String, Expression> extras) {
    }
}

