/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import java.util.Arrays;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Greatest;

public final class GreatestBytesRefEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(GreatestBytesRefEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator[] values;
    private final DriverContext driverContext;
    private Warnings warnings;

    public GreatestBytesRefEvaluator(Source source, EvalOperator.ExpressionEvaluator[] values, DriverContext driverContext) {
        this.source = source;
        this.values = values;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        BytesRefBlock[] valuesBlocks = new BytesRefBlock[this.values.length];
        try (Releasable valuesRelease = Releasables.wrap((Releasable[])valuesBlocks);){
            for (int i = 0; i < valuesBlocks.length; ++i) {
                valuesBlocks[i] = (BytesRefBlock)this.values[i].eval(page);
            }
            BytesRefVector[] valuesVectors = new BytesRefVector[this.values.length];
            for (int i = 0; i < valuesBlocks.length; ++i) {
                valuesVectors[i] = valuesBlocks[i].asVector();
                if (valuesVectors[i] != null) continue;
                BytesRefBlock bytesRefBlock = this.eval(page.getPositionCount(), valuesBlocks);
                return bytesRefBlock;
            }
            BytesRefBlock bytesRefBlock = this.eval(page.getPositionCount(), valuesVectors).asBlock();
            return bytesRefBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        for (EvalOperator.ExpressionEvaluator e : this.values) {
            baseRamBytesUsed += e.baseRamBytesUsed();
        }
        return baseRamBytesUsed;
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock[] valuesBlocks) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef[] valuesValues = new BytesRef[this.values.length];
            BytesRef[] valuesScratch = new BytesRef[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                valuesScratch[i] = new BytesRef();
            }
            block10: for (int p = 0; p < positionCount; ++p) {
                int i;
                block11: for (i = 0; i < valuesBlocks.length; ++i) {
                    switch (valuesBlocks[i].getValueCount(p)) {
                        case 0: {
                            result.appendNull();
                            continue block10;
                        }
                        case 1: {
                            continue block11;
                        }
                        default: {
                            this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                            result.appendNull();
                            continue block10;
                        }
                    }
                }
                for (i = 0; i < valuesBlocks.length; ++i) {
                    int o = valuesBlocks[i].getFirstValueIndex(p);
                    valuesValues[i] = valuesBlocks[i].getBytesRef(o, valuesScratch[i]);
                }
                result.appendBytesRef(Greatest.process(valuesValues));
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefVector eval(int positionCount, BytesRefVector[] valuesVectors) {
        try (BytesRefVector.Builder result = this.driverContext.blockFactory().newBytesRefVectorBuilder(positionCount);){
            BytesRef[] valuesValues = new BytesRef[this.values.length];
            BytesRef[] valuesScratch = new BytesRef[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                valuesScratch[i] = new BytesRef();
            }
            for (int p = 0; p < positionCount; ++p) {
                for (int i = 0; i < valuesVectors.length; ++i) {
                    valuesValues[i] = valuesVectors[i].getBytesRef(p, valuesScratch[i]);
                }
                result.appendBytesRef(Greatest.process(valuesValues));
            }
            BytesRefVector bytesRefVector = result.build();
            return bytesRefVector;
        }
    }

    public String toString() {
        return "GreatestBytesRefEvaluator[values=" + Arrays.toString(this.values) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException(() -> Releasables.close((Releasable[])this.values));
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory[] values;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory[] values) {
            this.source = source;
            this.values = values;
        }

        public GreatestBytesRefEvaluator get(DriverContext context) {
            EvalOperator.ExpressionEvaluator[] values = (EvalOperator.ExpressionEvaluator[])Arrays.stream(this.values).map(a -> a.get(context)).toArray(EvalOperator.ExpressionEvaluator[]::new);
            return new GreatestBytesRefEvaluator(this.source, values, context);
        }

        public String toString() {
            return "GreatestBytesRefEvaluator[values=" + Arrays.toString(this.values) + "]";
        }
    }
}

