/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.inference;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.inference.InferenceFunction;

public class TextEmbedding
extends InferenceFunction<TextEmbedding> {
    private final Expression inferenceId;
    private final Expression inputText;

    @FunctionInfo(returnType={"dense_vector"}, description="Generates dense vector embeddings from text input using a specified [inference endpoint](docs-content://explore-analyze/elastic-inference/inference-api.md). Use this function to generate query vectors for KNN searches against your vectorized data or others dense vector based operations.", appliesTo={@FunctionAppliesTo(version="9.3", lifeCycle=FunctionAppliesToLifecycle.PREVIEW)}, preview=true, examples={@Example(description="Basic text embedding generation from a text string using an inference endpoint.", file="text-embedding", tag="text-embedding-eval"), @Example(description="Generate text embeddings and store them in a variable for reuse in KNN vector search queries.", file="text-embedding", tag="text-embedding-knn"), @Example(description="Directly embed text within a KNN query for streamlined vector search without intermediate variables.", file="text-embedding", tag="text-embedding-knn-inline")})
    public TextEmbedding(Source source, @Param(name="text", type={"keyword"}, description="Text string to generate embeddings from. Must be a non-null literal string value.") Expression inputText, @Param(name="inference_id", type={"keyword"}, description="Identifier of an existing inference endpoint the that will generate the embeddings. The inference endpoint must have the `text_embedding` task type and should use the same model that was used to embed your indexed data.") Expression inferenceId) {
        super(source, List.of(inputText, inferenceId));
        this.inferenceId = inferenceId;
        this.inputText = inputText;
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("doesn't escape the node");
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("doesn't escape the node");
    }

    public Expression inputText() {
        return this.inputText;
    }

    @Override
    public Expression inferenceId() {
        return this.inferenceId;
    }

    public boolean foldable() {
        return this.inferenceId.foldable() && this.inputText.foldable();
    }

    public DataType dataType() {
        return this.inputText.dataType() == DataType.NULL ? DataType.NULL : DataType.DENSE_VECTOR;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution textResolution = TypeResolutions.isNotNull((Expression)this.inputText, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST).and(TypeResolutions.isFoldable((Expression)this.inputText, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST)).and(TypeResolutions.isType((Expression)this.inputText, arg_0 -> DataType.KEYWORD.equals(arg_0), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"string"}));
        if (textResolution.unresolved()) {
            return textResolution;
        }
        Expression.TypeResolution inferenceIdResolution = TypeResolutions.isNotNull((Expression)this.inferenceId, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND).and(TypeResolutions.isType((Expression)this.inferenceId, arg_0 -> DataType.KEYWORD.equals(arg_0), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"string"})).and(TypeResolutions.isFoldable((Expression)this.inferenceId, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND));
        if (inferenceIdResolution.unresolved()) {
            return inferenceIdResolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    @Override
    public TaskType taskType() {
        return TaskType.TEXT_EMBEDDING;
    }

    @Override
    public TextEmbedding withInferenceResolutionError(String inferenceId, String error) {
        return new TextEmbedding(this.source(), this.inputText, (Expression)new UnresolvedAttribute(this.inferenceId().source(), inferenceId, error));
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new TextEmbedding(this.source(), newChildren.get(0), newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, TextEmbedding::new, (Object)this.inputText, (Object)this.inferenceId);
    }

    public String toString() {
        return "TEXT_EMBEDDING(" + String.valueOf(this.inputText) + ", " + String.valueOf(this.inferenceId) + ")";
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TextEmbedding textEmbedding = (TextEmbedding)((Object)o);
        return Objects.equals(this.inferenceId, textEmbedding.inferenceId) && Objects.equals(this.inputText, textEmbedding.inputText);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.inferenceId, this.inputText);
    }
}

