/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.function.LongConsumer;
import org.elasticsearch.index.fielddata.SortingNumericLongValues;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoShapeValues;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoGridTiler;

final class GeoShapeCellValues
extends SortingNumericLongValues {
    private final GeoShapeValues geoShapeValues;
    private final GeoGridTiler tiler;

    GeoShapeCellValues(GeoShapeValues geoShapeValues, GeoGridTiler tiler, LongConsumer circuitBreakerConsumer) {
        super(circuitBreakerConsumer);
        this.geoShapeValues = geoShapeValues;
        this.tiler = tiler;
    }

    public boolean advanceExact(int docId) throws IOException {
        if (this.geoShapeValues.advanceExact(docId)) {
            int j = this.tiler.setValues(this, (GeoShapeValues.GeoShapeValue)this.geoShapeValues.value());
            this.resize(j);
            this.sort();
            return true;
        }
        return false;
    }

    long[] getValues() {
        return this.values;
    }

    void resizeCell(int newSize) {
        this.resize(newSize);
    }

    void add(int idx, long value) {
        this.values[idx] = value;
    }
}

