/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.AbstractTDigestPercentilesAggregator;
import org.elasticsearch.search.aggregations.metrics.InternalTDigestPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.TDigestExecutionHint;
import org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

class TDigestPercentileRanksAggregator
extends AbstractTDigestPercentilesAggregator {
    TDigestPercentileRanksAggregator(String name, ValuesSourceConfig config, AggregationContext context, Aggregator parent, double[] percents, double compression, TDigestExecutionHint executionHint, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
        super(name, config, context, parent, percents, compression, executionHint, keyed, formatter, metadata);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        TDigestState state = this.getState(owningBucketOrdinal);
        if (state == null) {
            return this.buildEmptyAggregation();
        }
        return new InternalTDigestPercentileRanks(this.name, this.keys, state, this.keyed, this.formatter, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return InternalTDigestPercentileRanks.empty(this.name, this.keys, this.compression, this.executionHint, this.keyed, this.formatter, this.metadata());
    }

    @Override
    public double metric(String name, long bucketOrd) {
        TDigestState state = this.getState(bucketOrd);
        if (state == null) {
            return Double.NaN;
        }
        return InternalTDigestPercentileRanks.percentileRank(state, Double.parseDouble(name));
    }
}

