/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class MultiGetShardResponse
extends ActionResponse {
    final List<Integer> locations;
    final List<GetResponse> responses;
    final List<MultiGetResponse.Failure> failures;

    MultiGetShardResponse() {
        this.locations = new ArrayList<Integer>();
        this.responses = new ArrayList<GetResponse>();
        this.failures = new ArrayList<MultiGetResponse.Failure>();
    }

    MultiGetShardResponse(StreamInput in) throws IOException {
        int size = in.readVInt();
        this.locations = new ArrayList<Integer>(size);
        this.responses = new ArrayList<GetResponse>(size);
        this.failures = new ArrayList<MultiGetResponse.Failure>(size);
        for (int i = 0; i < size; ++i) {
            this.locations.add(in.readVInt());
            if (in.readBoolean()) {
                this.responses.add(new GetResponse(in));
            } else {
                this.responses.add(null);
            }
            if (in.readBoolean()) {
                this.failures.add(new MultiGetResponse.Failure(in));
                continue;
            }
            this.failures.add(null);
        }
    }

    public void add(int location, GetResponse response) {
        this.locations.add(location);
        this.responses.add(response);
        this.failures.add(null);
    }

    public void add(int location, MultiGetResponse.Failure failure) {
        this.locations.add(location);
        this.responses.add(null);
        this.failures.add(failure);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.locations.size());
        for (int i = 0; i < this.locations.size(); ++i) {
            out.writeVInt(this.locations.get(i));
            if (this.responses.get(i) == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.responses.get(i).writeTo(out);
            }
            if (this.failures.get(i) == null) {
                out.writeBoolean(false);
                continue;
            }
            out.writeBoolean(true);
            this.failures.get(i).writeTo(out);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiGetShardResponse)) {
            return false;
        }
        MultiGetShardResponse other = (MultiGetShardResponse)o;
        return Objects.equals(this.locations, other.locations) && Objects.equals(this.responses, other.responses);
    }

    public int hashCode() {
        return Objects.hash(this.locations, this.responses);
    }
}

