/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public final class CommonStatsFlags
implements Writeable,
Cloneable {
    public static final CommonStatsFlags ALL = new CommonStatsFlags(new Flag[0]).all();
    public static final CommonStatsFlags SHARD_LEVEL = new CommonStatsFlags(new Flag[0]).all().set(Flag.Mappings, false);
    public static final CommonStatsFlags NONE = new CommonStatsFlags(new Flag[0]).clear();
    private EnumSet<Flag> flags = EnumSet.allOf(Flag.class);
    private String[] groups = null;
    private String[] fieldDataFields = null;
    private String[] completionDataFields = null;
    private boolean includeSegmentFileSizes = false;
    private boolean includeUnloadedSegments = false;

    public CommonStatsFlags(Flag ... flags) {
        if (flags.length > 0) {
            this.clear();
            Collections.addAll(this.flags, flags);
        }
    }

    public CommonStatsFlags(StreamInput in) throws IOException {
        long longFlags = in.readLong();
        this.flags.clear();
        for (Flag flag : Flag.values()) {
            if ((longFlags & (long)(1 << flag.getIndex())) == 0L) continue;
            this.flags.add(flag);
        }
        this.groups = in.readStringArray();
        this.fieldDataFields = in.readStringArray();
        this.completionDataFields = in.readStringArray();
        this.includeSegmentFileSizes = in.readBoolean();
        this.includeUnloadedSegments = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        long longFlags = 0L;
        for (Flag flag : this.flags) {
            longFlags |= (long)(1 << flag.getIndex());
        }
        out.writeLong(longFlags);
        out.writeStringArrayNullable(this.groups);
        out.writeStringArrayNullable(this.fieldDataFields);
        out.writeStringArrayNullable(this.completionDataFields);
        out.writeBoolean(this.includeSegmentFileSizes);
        out.writeBoolean(this.includeUnloadedSegments);
    }

    public CommonStatsFlags all() {
        this.flags = EnumSet.allOf(Flag.class);
        this.groups = null;
        this.fieldDataFields = null;
        this.completionDataFields = null;
        this.includeSegmentFileSizes = false;
        this.includeUnloadedSegments = false;
        return this;
    }

    public CommonStatsFlags clear() {
        this.flags = EnumSet.noneOf(Flag.class);
        this.groups = null;
        this.fieldDataFields = null;
        this.completionDataFields = null;
        this.includeSegmentFileSizes = false;
        this.includeUnloadedSegments = false;
        return this;
    }

    public boolean anySet() {
        return !this.flags.isEmpty();
    }

    public Flag[] getFlags() {
        return this.flags.toArray(new Flag[this.flags.size()]);
    }

    public CommonStatsFlags groups(String ... groups) {
        this.groups = groups;
        return this;
    }

    public String[] groups() {
        return this.groups;
    }

    public CommonStatsFlags fieldDataFields(String ... fieldDataFields) {
        this.fieldDataFields = fieldDataFields;
        return this;
    }

    public String[] fieldDataFields() {
        return this.fieldDataFields;
    }

    public CommonStatsFlags completionDataFields(String ... completionDataFields) {
        this.completionDataFields = completionDataFields;
        return this;
    }

    public String[] completionDataFields() {
        return this.completionDataFields;
    }

    public CommonStatsFlags includeSegmentFileSizes(boolean includeSegmentFileSizes) {
        this.includeSegmentFileSizes = includeSegmentFileSizes;
        return this;
    }

    public CommonStatsFlags includeUnloadedSegments(boolean includeUnloadedSegments) {
        this.includeUnloadedSegments = includeUnloadedSegments;
        return this;
    }

    public boolean includeUnloadedSegments() {
        return this.includeUnloadedSegments;
    }

    public boolean includeSegmentFileSizes() {
        return this.includeSegmentFileSizes;
    }

    public boolean isSet(Flag flag) {
        return this.flags.contains((Object)flag);
    }

    boolean unSet(Flag flag) {
        return this.flags.remove((Object)flag);
    }

    void set(Flag flag) {
        this.flags.add(flag);
    }

    public CommonStatsFlags set(Flag flag, boolean add) {
        if (add) {
            this.set(flag);
        } else {
            this.unSet(flag);
        }
        return this;
    }

    public CommonStatsFlags clone() {
        try {
            CommonStatsFlags cloned = (CommonStatsFlags)super.clone();
            cloned.flags = this.flags.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static enum Flag {
        Store("store", 0),
        Indexing("indexing", 1),
        Get("get", 2),
        Search("search", 3),
        Merge("merge", 4),
        Flush("flush", 5),
        Refresh("refresh", 6),
        QueryCache("query_cache", 7),
        FieldData("fielddata", 8),
        Docs("docs", 9),
        Warmer("warmer", 10),
        Completion("completion", 11),
        Segments("segments", 12),
        Translog("translog", 13),
        RequestCache("request_cache", 15),
        Recovery("recovery", 16),
        Bulk("bulk", 17),
        Shards("shard_stats", 18),
        Mappings("mappings", 19),
        DenseVector("dense_vector", 20),
        SparseVector("sparse_vector", 21);

        private final String restName;
        private final int index;

        private Flag(String restName, int index) {
            this.restName = restName;
            this.index = index;
        }

        public String getRestName() {
            return this.restName;
        }

        private int getIndex() {
            return this.index;
        }
    }
}

