/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ilm.action.ILMActions;
import org.elasticsearch.xpack.core.ilm.action.RetryActionRequest;

public class RestRetryAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_ilm/retry"));
    }

    public String getName() {
        return "ilm_retry_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        String[] indices = Strings.splitStringByCommaToArray((String)restRequest.param("index"));
        RetryActionRequest request = new RetryActionRequest(RestUtils.getMasterNodeTimeout((RestRequest)restRequest), RestUtils.getAckTimeout((RestRequest)restRequest), indices);
        request.indices(indices);
        request.indicesOptions(IndicesOptions.fromRequest((RestRequest)restRequest, (IndicesOptions)IndicesOptions.strictExpandOpen()));
        return channel -> client.execute(ILMActions.RETRY, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

