/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.errorquery;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.script.LongFieldScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.test.errorquery.ErrorQueryBuilder;

public class ErrorQueryPlugin
extends Plugin
implements SearchPlugin,
ScriptPlugin {
    public static final String FAILING_FIELD_LANG = "failing_field";

    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Collections.singletonList(new SearchPlugin.QuerySpec("error_query", ErrorQueryBuilder::new, p -> (ErrorQueryBuilder)((Object)((Object)ErrorQueryBuilder.PARSER.parse(p, null)))));
    }

    public ScriptEngine getScriptEngine(Settings settings, Collection<ScriptContext<?>> contexts) {
        return new ScriptEngine(this){

            public String getType() {
                return ErrorQueryPlugin.FAILING_FIELD_LANG;
            }

            public <FactoryType> FactoryType compile(String name, String code, ScriptContext<FactoryType> context, Map<String, String> params) {
                return (FactoryType)new LongFieldScript.Factory(this){

                    public LongFieldScript.LeafFactory newFactory(String fieldName, Map<String, Object> params, SearchLookup searchLookup, OnScriptError onScriptError) {
                        return ctx -> new LongFieldScript(this, fieldName, params, searchLookup, onScriptError, ctx){

                            public void execute() {
                                throw new IllegalStateException("Accessing failing field");
                            }
                        };
                    }
                };
            }

            public Set<ScriptContext<?>> getSupportedContexts() {
                return Set.of(LongFieldScript.CONTEXT);
            }
        };
    }
}

