/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs;

import com.nvidia.cuvs.CagraIndexParams;

public class CagraMergeParams {
    private final CagraIndexParams outputIndexParams;
    private final MergeStrategy strategy;

    private CagraMergeParams(CagraIndexParams outputIndexParams, MergeStrategy strategy) {
        this.outputIndexParams = outputIndexParams;
        this.strategy = strategy;
    }

    public CagraIndexParams getOutputIndexParams() {
        return this.outputIndexParams;
    }

    public MergeStrategy getStrategy() {
        return this.strategy;
    }

    public static enum MergeStrategy {
        PHYSICAL(0),
        LOGICAL(1);

        public final int value;

        private MergeStrategy(int value) {
            this.value = value;
        }
    }

    public static class Builder {
        private CagraIndexParams outputIndexParams = new CagraIndexParams.Builder().build();
        private MergeStrategy strategy = MergeStrategy.PHYSICAL;

        public Builder withOutputIndexParams(CagraIndexParams outputIndexParams) {
            this.outputIndexParams = outputIndexParams;
            return this;
        }

        public Builder withStrategy(MergeStrategy strategy) {
            this.strategy = strategy;
            return this;
        }

        public CagraMergeParams build() {
            return new CagraMergeParams(this.outputIndexParams, this.strategy);
        }
    }
}

