/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto;

import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.proto.AbstractSqlRequest;
import org.elasticsearch.xpack.sql.proto.CoreProtocol;
import org.elasticsearch.xpack.sql.proto.RequestInfo;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;
import org.elasticsearch.xpack.sql.proto.core.Nullable;
import org.elasticsearch.xpack.sql.proto.core.TimeValue;

public class SqlQueryRequest
extends AbstractSqlRequest {
    @Nullable
    private final String cursor;
    private final String query;
    private final ZoneId zoneId;
    private final String catalog;
    private final int fetchSize;
    private final TimeValue requestTimeout;
    private final TimeValue pageTimeout;
    private final Boolean columnar;
    private final List<SqlTypedParamValue> params;
    private final boolean fieldMultiValueLeniency;
    private final boolean indexIncludeFrozen;
    private final Boolean binaryCommunication;
    private final TimeValue waitForCompletionTimeout;
    private final boolean keepOnCompletion;
    private final TimeValue keepAlive;
    private final boolean allowPartialSearchResults;

    public SqlQueryRequest(String query, List<SqlTypedParamValue> params, ZoneId zoneId, String catalog, int fetchSize, TimeValue requestTimeout, TimeValue pageTimeout, Boolean columnar, String cursor, RequestInfo requestInfo, boolean fieldMultiValueLeniency, boolean indexIncludeFrozen, Boolean binaryCommunication, TimeValue waitForCompletionTimeout, boolean keepOnCompletion, TimeValue keepAlive, boolean allowPartialSearchResults) {
        super(requestInfo);
        this.query = query;
        this.params = params;
        this.zoneId = zoneId;
        this.catalog = catalog;
        this.fetchSize = fetchSize;
        this.requestTimeout = requestTimeout;
        this.pageTimeout = pageTimeout;
        this.columnar = columnar;
        this.cursor = cursor;
        this.fieldMultiValueLeniency = fieldMultiValueLeniency;
        this.indexIncludeFrozen = indexIncludeFrozen;
        this.binaryCommunication = binaryCommunication;
        this.waitForCompletionTimeout = waitForCompletionTimeout;
        this.keepOnCompletion = keepOnCompletion;
        this.keepAlive = keepAlive;
        this.allowPartialSearchResults = allowPartialSearchResults;
    }

    public SqlQueryRequest(String query, List<SqlTypedParamValue> params, ZoneId zoneId, String catalog, int fetchSize, TimeValue requestTimeout, TimeValue pageTimeout, Boolean columnar, String cursor, RequestInfo requestInfo, boolean fieldMultiValueLeniency, boolean indexIncludeFrozen, Boolean binaryCommunication, boolean allowPartialSearchResults) {
        this(query, params, zoneId, catalog, fetchSize, requestTimeout, pageTimeout, columnar, cursor, requestInfo, fieldMultiValueLeniency, indexIncludeFrozen, binaryCommunication, CoreProtocol.DEFAULT_WAIT_FOR_COMPLETION_TIMEOUT, CoreProtocol.DEFAULT_KEEP_ON_COMPLETION, CoreProtocol.DEFAULT_KEEP_ALIVE, allowPartialSearchResults);
    }

    public SqlQueryRequest(String cursor, TimeValue requestTimeout, TimeValue pageTimeout, RequestInfo requestInfo, boolean binaryCommunication, boolean allowPartialSearchResults) {
        this("", Collections.emptyList(), CoreProtocol.TIME_ZONE, null, 1000, requestTimeout, pageTimeout, false, cursor, requestInfo, false, false, binaryCommunication, allowPartialSearchResults);
    }

    public String cursor() {
        return this.cursor;
    }

    public String query() {
        return this.query;
    }

    public List<SqlTypedParamValue> params() {
        return this.params;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    public String catalog() {
        return this.catalog;
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public TimeValue requestTimeout() {
        return this.requestTimeout;
    }

    public TimeValue pageTimeout() {
        return this.pageTimeout;
    }

    public Boolean columnar() {
        return this.columnar;
    }

    public boolean fieldMultiValueLeniency() {
        return this.fieldMultiValueLeniency;
    }

    public boolean indexIncludeFrozen() {
        return this.indexIncludeFrozen;
    }

    public Boolean binaryCommunication() {
        return this.binaryCommunication;
    }

    public TimeValue waitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }

    public boolean keepOnCompletion() {
        return this.keepOnCompletion;
    }

    public TimeValue keepAlive() {
        return this.keepAlive;
    }

    public boolean allowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SqlQueryRequest that = (SqlQueryRequest)o;
        return this.fetchSize == that.fetchSize && this.fieldMultiValueLeniency == that.fieldMultiValueLeniency && this.indexIncludeFrozen == that.indexIncludeFrozen && this.keepOnCompletion == that.keepOnCompletion && this.allowPartialSearchResults == that.allowPartialSearchResults && Objects.equals(this.query, that.query) && Objects.equals(this.params, that.params) && Objects.equals(this.zoneId, that.zoneId) && Objects.equals(this.catalog, that.catalog) && Objects.equals(this.requestTimeout, that.requestTimeout) && Objects.equals(this.pageTimeout, that.pageTimeout) && Objects.equals(this.columnar, that.columnar) && Objects.equals(this.cursor, that.cursor) && Objects.equals(this.binaryCommunication, that.binaryCommunication) && Objects.equals(this.waitForCompletionTimeout, that.waitForCompletionTimeout) && Objects.equals(this.keepAlive, that.keepAlive);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.query, this.zoneId, this.catalog, this.fetchSize, this.requestTimeout, this.pageTimeout, this.columnar, this.cursor, this.fieldMultiValueLeniency, this.indexIncludeFrozen, this.binaryCommunication, this.waitForCompletionTimeout, this.keepOnCompletion, this.keepAlive, this.allowPartialSearchResults);
    }
}

