/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.action.downsample.DownsampleConfig;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.flattened.FlattenedFieldMapper;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.xpack.aggregatemetric.mapper.AggregateMetricDoubleFieldMapper;
import org.elasticsearch.xpack.downsample.AbstractDownsampleFieldProducer;
import org.elasticsearch.xpack.downsample.AggregateSubMetricFieldValueFetcher;
import org.elasticsearch.xpack.downsample.LastValueFieldProducer;
import org.elasticsearch.xpack.downsample.MetricFieldProducer;

class FieldValueFetcher {
    protected final String name;
    protected final MappedFieldType fieldType;
    protected final IndexFieldData<?> fieldData;
    protected final AbstractDownsampleFieldProducer fieldProducer;

    protected FieldValueFetcher(String name, MappedFieldType fieldType, IndexFieldData<?> fieldData, DownsampleConfig.SamplingMethod samplingMethod) {
        this.name = name;
        this.fieldType = fieldType;
        this.fieldData = fieldData;
        this.fieldProducer = this.createFieldProducer(samplingMethod);
    }

    public String name() {
        return this.name;
    }

    public FormattedDocValues getLeaf(LeafReaderContext context) {
        DocValueFormat format = this.fieldType.docValueFormat(null, null);
        return this.fieldData.load(context).getFormattedValues(format);
    }

    public SortedNumericDoubleValues getNumericLeaf(LeafReaderContext context) {
        LeafNumericFieldData numericFieldData = (LeafNumericFieldData)this.fieldData.load(context);
        return numericFieldData.getDoubleValues();
    }

    public AbstractDownsampleFieldProducer fieldProducer() {
        return this.fieldProducer;
    }

    private AbstractDownsampleFieldProducer createFieldProducer(DownsampleConfig.SamplingMethod samplingMethod) {
        assert (!"aggregate_metric_double".equals(this.fieldType.typeName())) : "Aggregate metric double should be handled by a dedicated FieldValueFetcher";
        if (this.fieldType.getMetricType() != null) {
            return switch (this.fieldType.getMetricType()) {
                default -> throw new MatchException(null, null);
                case TimeSeriesParams.MetricType.GAUGE -> MetricFieldProducer.createFieldProducerForGauge(this.name(), samplingMethod);
                case TimeSeriesParams.MetricType.COUNTER -> LastValueFieldProducer.createForMetric(this.name());
                case TimeSeriesParams.MetricType.HISTOGRAM -> throw new IllegalArgumentException("Unsupported metric type [histogram] for downsampling, coming soon");
                case TimeSeriesParams.MetricType.POSITION -> throw new IllegalArgumentException("Unsupported metric type [position] for down-sampling");
            };
        }
        return LastValueFieldProducer.createForLabel(this.name(), this.fieldType.typeName());
    }

    static List<FieldValueFetcher> create(SearchExecutionContext context, String[] fields, DownsampleConfig.SamplingMethod samplingMethod) {
        ArrayList<FieldValueFetcher> fetchers = new ArrayList<FieldValueFetcher>();
        for (String field : fields) {
            IndexFieldData fieldData;
            MappedFieldType fieldType = context.getFieldType(field);
            assert (fieldType != null) : "Unknown field type for field: [" + field + "]";
            if (fieldType instanceof AggregateMetricDoubleFieldMapper.AggregateMetricDoubleFieldType) {
                AggregateMetricDoubleFieldMapper.AggregateMetricDoubleFieldType aggMetricFieldType = (AggregateMetricDoubleFieldMapper.AggregateMetricDoubleFieldType)fieldType;
                fetchers.addAll(AggregateSubMetricFieldValueFetcher.create(context, aggMetricFieldType, samplingMethod));
                continue;
            }
            if (!context.fieldExistsInIndex(field)) continue;
            if (fieldType instanceof FlattenedFieldMapper.RootFlattenedFieldType) {
                FlattenedFieldMapper.RootFlattenedFieldType flattenedFieldType = (FlattenedFieldMapper.RootFlattenedFieldType)fieldType;
                MappedFieldType keyedFieldType = flattenedFieldType.getKeyedFieldType();
                fieldData = context.getForField(keyedFieldType, MappedFieldType.FielddataOperation.SEARCH);
            } else {
                fieldData = context.getForField(fieldType, MappedFieldType.FielddataOperation.SEARCH);
            }
            String fieldName = context.isMultiField(field) ? fieldType.name().substring(0, fieldType.name().lastIndexOf(46)) : fieldType.name();
            fetchers.add(new FieldValueFetcher(fieldName, fieldType, fieldData, samplingMethod));
        }
        return Collections.unmodifiableList(fetchers);
    }
}

