/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.downsample.DownsampleConfig;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xpack.aggregatemetric.mapper.AggregateMetricDoubleFieldMapper;
import org.elasticsearch.xpack.downsample.AbstractDownsampleFieldProducer;
import org.elasticsearch.xpack.downsample.FieldValueFetcher;
import org.elasticsearch.xpack.downsample.LastValueFieldProducer;
import org.elasticsearch.xpack.downsample.MetricFieldProducer;

public final class AggregateSubMetricFieldValueFetcher
extends FieldValueFetcher {
    private final AggregateMetricDoubleFieldMapper.AggregateMetricDoubleFieldType aggMetricFieldType;
    private final AbstractDownsampleFieldProducer fieldProducer;

    AggregateSubMetricFieldValueFetcher(MappedFieldType fieldType, AggregateMetricDoubleFieldMapper.AggregateMetricDoubleFieldType aggMetricFieldType, IndexFieldData<?> fieldData, DownsampleConfig.SamplingMethod samplingMethod) {
        super(fieldType.name(), fieldType, fieldData, samplingMethod);
        this.aggMetricFieldType = aggMetricFieldType;
        this.fieldProducer = this.createFieldProducer(samplingMethod);
    }

    @Override
    public AbstractDownsampleFieldProducer fieldProducer() {
        return this.fieldProducer;
    }

    static List<AggregateSubMetricFieldValueFetcher> create(SearchExecutionContext context, AggregateMetricDoubleFieldMapper.AggregateMetricDoubleFieldType aggMetricFieldType, DownsampleConfig.SamplingMethod samplingMethod) {
        ArrayList<AggregateSubMetricFieldValueFetcher> fetchers = new ArrayList<AggregateSubMetricFieldValueFetcher>();
        for (NumberFieldMapper.NumberFieldType metricSubField : aggMetricFieldType.getMetricFields().values()) {
            if (!context.fieldExistsInIndex(metricSubField.name())) continue;
            IndexFieldData fieldData = context.getForField((MappedFieldType)metricSubField, MappedFieldType.FielddataOperation.SEARCH);
            fetchers.add(new AggregateSubMetricFieldValueFetcher((MappedFieldType)metricSubField, aggMetricFieldType, fieldData, samplingMethod));
        }
        return fetchers;
    }

    private AbstractDownsampleFieldProducer createFieldProducer(DownsampleConfig.SamplingMethod samplingMethod) {
        AggregateMetricDoubleFieldMapper.Metric metric = null;
        for (Map.Entry e : this.aggMetricFieldType.getMetricFields().entrySet()) {
            NumberFieldMapper.NumberFieldType metricSubField = (NumberFieldMapper.NumberFieldType)e.getValue();
            if (!metricSubField.name().equals(this.name())) continue;
            metric = (AggregateMetricDoubleFieldMapper.Metric)e.getKey();
            break;
        }
        assert (metric != null) : "Cannot resolve metric type for field " + this.name();
        if (this.aggMetricFieldType.getMetricType() != null) {
            if (samplingMethod != DownsampleConfig.SamplingMethod.LAST_VALUE) {
                return new MetricFieldProducer.AggregateSubMetricFieldProducer(this.aggMetricFieldType.name(), metric);
            }
            return LastValueFieldProducer.createForAggregateSubMetricMetric(this.aggMetricFieldType.name(), metric);
        }
        return LastValueFieldProducer.createForAggregateSubMetricLabel(this.aggMetricFieldType.name(), metric);
    }
}

