/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.ConditionalTokenFilter;
import org.apache.lucene.analysis.miscellaneous.RemoveDuplicatesTokenFilter;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.AttributeSource;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.AnalysisMode;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;

public class MultiplexerTokenFilterFactory
extends AbstractTokenFilterFactory {
    private List<String> filterNames;
    private final boolean preserveOriginal;

    public MultiplexerTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) throws IOException {
        super(name);
        this.filterNames = settings.getAsList("filters");
        this.preserveOriginal = settings.getAsBoolean("preserve_original", Boolean.valueOf(true));
    }

    public TokenStream create(TokenStream tokenStream) {
        throw new UnsupportedOperationException("TokenFilterFactory.getChainAwareTokenFilterFactory() must be called first");
    }

    public TokenFilterFactory getSynonymFilter() {
        throw new IllegalArgumentException("Token filter [" + this.name() + "] cannot be used to parse synonyms");
    }

    public TokenFilterFactory getChainAwareTokenFilterFactory(IndexService.IndexCreationContext context, TokenizerFactory tokenizer, List<CharFilterFactory> charFilters, List<TokenFilterFactory> previousTokenFilters, Function<String, TokenFilterFactory> allFilters) {
        final ArrayList<TokenFilterFactory> filters = new ArrayList<TokenFilterFactory>();
        if (this.preserveOriginal) {
            filters.add(IDENTITY_FILTER);
        }
        AnalysisMode mode = AnalysisMode.ALL;
        for (String filter : this.filterNames) {
            String[] parts = Strings.tokenizeToStringArray((String)filter, (String)",");
            if (parts.length == 1) {
                TokenFilterFactory factory = this.resolveFilterFactory(allFilters, parts[0]);
                factory = factory.getChainAwareTokenFilterFactory(context, tokenizer, charFilters, previousTokenFilters, allFilters);
                filters.add(factory);
                mode = mode.merge(factory.getAnalysisMode());
                continue;
            }
            ArrayList<TokenFilterFactory> existingChain = new ArrayList<TokenFilterFactory>(previousTokenFilters);
            ArrayList<TokenFilterFactory> chain = new ArrayList<TokenFilterFactory>();
            for (String subfilter : parts) {
                TokenFilterFactory factory = this.resolveFilterFactory(allFilters, subfilter);
                factory = factory.getChainAwareTokenFilterFactory(context, tokenizer, charFilters, existingChain, allFilters);
                chain.add(factory);
                existingChain.add(factory);
                mode = mode.merge(factory.getAnalysisMode());
            }
            filters.add(MultiplexerTokenFilterFactory.chainFilters(filter, chain));
        }
        final AnalysisMode analysisMode = mode;
        return new TokenFilterFactory(){

            public String name() {
                return MultiplexerTokenFilterFactory.this.name();
            }

            public TokenStream create(TokenStream tokenStream) {
                ArrayList<Function<TokenStream, TokenStream>> functions = new ArrayList<Function<TokenStream, TokenStream>>();
                for (TokenFilterFactory tff : filters) {
                    functions.add(arg_0 -> ((TokenFilterFactory)tff).create(arg_0));
                }
                return new RemoveDuplicatesTokenFilter((TokenStream)new MultiplexTokenFilter(tokenStream, functions));
            }

            public TokenFilterFactory getSynonymFilter() {
                throw new IllegalArgumentException("Token filter [" + this.name() + "] cannot be used to parse synonyms");
            }

            public AnalysisMode getAnalysisMode() {
                return analysisMode;
            }
        };
    }

    private static TokenFilterFactory chainFilters(final String name, final List<TokenFilterFactory> filters) {
        return new TokenFilterFactory(){

            public String name() {
                return name;
            }

            public TokenStream create(TokenStream tokenStream) {
                for (TokenFilterFactory tff : filters) {
                    tokenStream = tff.create(tokenStream);
                }
                return tokenStream;
            }
        };
    }

    private TokenFilterFactory resolveFilterFactory(Function<String, TokenFilterFactory> factories, String name) {
        TokenFilterFactory factory = factories.apply(name);
        if (factory == null) {
            throw new IllegalArgumentException("Multiplexing filter [" + this.name() + "] refers to undefined tokenfilter [" + name + "]");
        }
        return factory;
    }

    private static final class MultiplexTokenFilter
    extends TokenFilter {
        private final TokenStream source;
        private final int filterCount;
        private int selector;

        MultiplexTokenFilter(TokenStream input, List<Function<TokenStream, TokenStream>> filters) {
            super(input);
            MultiplexerFilter sourceFilter = new MultiplexerFilter(input);
            for (int i = 0; i < filters.size(); ++i) {
                final int slot = i;
                sourceFilter = new ConditionalTokenFilter((TokenStream)sourceFilter, filters.get(i)){

                    protected boolean shouldFilter() {
                        return slot == selector;
                    }
                };
            }
            this.source = sourceFilter;
            this.filterCount = filters.size();
            this.selector = this.filterCount - 1;
        }

        public boolean incrementToken() throws IOException {
            return this.source.incrementToken();
        }

        public void end() throws IOException {
            this.source.end();
        }

        public void reset() throws IOException {
            this.source.reset();
        }

        private final class MultiplexerFilter
        extends TokenFilter {
            AttributeSource.State state;
            PositionIncrementAttribute posIncAtt;

            private MultiplexerFilter(TokenStream input) {
                super(input);
                this.posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
            }

            public boolean incrementToken() throws IOException {
                if (MultiplexTokenFilter.this.selector >= MultiplexTokenFilter.this.filterCount - 1) {
                    MultiplexTokenFilter.this.selector = 0;
                    if (!this.input.incrementToken()) {
                        return false;
                    }
                    this.state = this.captureState();
                    return true;
                }
                this.restoreState(this.state);
                this.posIncAtt.setPositionIncrement(0);
                ++MultiplexTokenFilter.this.selector;
                return true;
            }

            public void reset() throws IOException {
                super.reset();
                MultiplexTokenFilter.this.selector = MultiplexTokenFilter.this.filterCount - 1;
                this.state = null;
            }
        }
    }
}

