/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.exponentialhistogram;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.exponentialhistogram.BucketIterator;
import org.elasticsearch.exponentialhistogram.CompressedExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramUtils;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramXContent;
import org.elasticsearch.exponentialhistogram.ZeroBucket;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.CompositeSyntheticFieldLoader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IgnoreMalformedStoredValues;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BytesRefsFromBinaryBlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.DoublesBlockLoader;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.CopyingXContentParser;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentSubParser;
import org.elasticsearch.xpack.analytics.mapper.ExponentialHistogramParser;
import org.elasticsearch.xpack.analytics.mapper.HistogramParser;
import org.elasticsearch.xpack.analytics.mapper.IndexWithCount;
import org.elasticsearch.xpack.analytics.mapper.ParsedHistogramConverter;
import org.elasticsearch.xpack.exponentialhistogram.fielddata.ExponentialHistogramValuesReader;
import org.elasticsearch.xpack.exponentialhistogram.fielddata.IndexExponentialHistogramFieldData;
import org.elasticsearch.xpack.exponentialhistogram.fielddata.LeafExponentialHistogramFieldData;

public class ExponentialHistogramFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "exponential_histogram";
    private static final Setting<Boolean> COERCE_SETTING = NumberFieldMapper.COERCE_SETTING;
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings()), (Boolean)COERCE_SETTING.get(c.getSettings())), ExponentialHistogramFieldMapper.notInMultiFields((String)"exponential_histogram"));
    private final Explicit<Boolean> ignoreMalformed;
    private final boolean ignoreMalformedByDefault;
    private final Explicit<Boolean> coerce;
    private final boolean coerceByDefault;
    private final TimeSeriesParams.MetricType metricType;

    private static ExponentialHistogramFieldMapper toType(FieldMapper in) {
        return (ExponentialHistogramFieldMapper)in;
    }

    static String zeroThresholdSubFieldName(String fullPath) {
        return fullPath + "._zero_threshold";
    }

    static String valuesCountSubFieldName(String fullPath) {
        return fullPath + "._values_count";
    }

    private static String valuesSumSubFieldName(String fullPath) {
        return fullPath + "._values_sum";
    }

    private static String valuesMinSubFieldName(String fullPath) {
        return fullPath + "._values_min";
    }

    private static String valuesMaxSubFieldName(String fullPath) {
        return fullPath + "._values_max";
    }

    ExponentialHistogramFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, Builder builder) {
        super(simpleName, mappedFieldType, builderParams);
        this.ignoreMalformed = (Explicit)builder.ignoreMalformed.getValue();
        this.ignoreMalformedByDefault = (Boolean)((Explicit)builder.ignoreMalformed.getDefaultValue()).value();
        this.coerce = (Explicit)builder.coerce.getValue();
        this.coerceByDefault = (Boolean)((Explicit)builder.coerce.getDefaultValue()).value();
        this.metricType = (TimeSeriesParams.MetricType)builder.metric.getValue();
    }

    public boolean ignoreMalformed() {
        return (Boolean)this.ignoreMalformed.value();
    }

    boolean coerce() {
        return (Boolean)this.coerce.value();
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.ignoreMalformedByDefault, this.coerceByDefault).metric(this.metricType).init(this);
    }

    protected void parseCreateField(DocumentParserContext context) {
        throw new UnsupportedOperationException("Parsing is implemented in parse(), this method should NEVER be called");
    }

    static FormattedDocValues createFormattedDocValues(final LeafReader reader, final String fieldName) {
        return new FormattedDocValues(){
            boolean hasNext = false;
            ExponentialHistogramValuesReader delegate;

            private ExponentialHistogramValuesReader lazyDelegate() throws IOException {
                if (this.delegate == null) {
                    this.delegate = new DocValuesReader(reader, fieldName);
                }
                return this.delegate;
            }

            public boolean advanceExact(int docId) throws IOException {
                this.hasNext = this.lazyDelegate().advanceExact(docId);
                return this.hasNext;
            }

            public int docValueCount() throws IOException {
                return 1;
            }

            public Object nextValue() throws IOException {
                if (!this.hasNext) {
                    throw new IllegalStateException("No value available, make sure to call advanceExact() first");
                }
                this.hasNext = false;
                return this.lazyDelegate().histogramValue();
            }
        };
    }

    protected boolean supportsParsingObject() {
        return true;
    }

    public void parse(DocumentParserContext context) throws IOException {
        context.path().add(this.leafName());
        boolean shouldStoreMalformedDataForSyntheticSource = context.mappingLookup().isSourceSynthetic() && this.ignoreMalformed();
        XContentSubParser subParser = null;
        XContentBuilder malformedDataForSyntheticSource = null;
        try {
            long totalValueCount;
            ExponentialHistogramParser.ParsedExponentialHistogram parsedHistogram;
            XContentParser.Token token = context.parser().currentToken();
            if (token == XContentParser.Token.VALUE_NULL) {
                context.path().remove();
                return;
            }
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)context.parser());
            if (shouldStoreMalformedDataForSyntheticSource) {
                CopyingXContentParser copyingParser = new CopyingXContentParser(context.parser());
                malformedDataForSyntheticSource = copyingParser.getBuilder();
                subParser = new XContentSubParser((XContentParser)copyingParser);
            } else {
                subParser = new XContentSubParser(context.parser());
            }
            subParser.nextToken();
            if (this.coerce() && subParser.currentToken() == XContentParser.Token.FIELD_NAME && HistogramParser.isHistogramSubFieldName((String)subParser.currentName())) {
                HistogramParser.ParsedHistogram parsedTDigest = HistogramParser.parse((String)this.fullPath(), (XContentParser)subParser);
                parsedHistogram = ParsedHistogramConverter.tDigestToExponential((HistogramParser.ParsedHistogram)parsedTDigest);
            } else {
                parsedHistogram = ExponentialHistogramParser.parse((String)this.fullPath(), (XContentParser)subParser);
            }
            if (context.doc().getByKey((Object)this.fieldType().name()) != null) {
                throw new IllegalArgumentException("Field [" + this.fullPath() + "] of type [" + this.typeName() + "] doesn't support indexing multiple values for the same field in the same document");
            }
            try {
                totalValueCount = ExponentialHistogramFieldMapper.getTotalValueCount(parsedHistogram);
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException("Field [" + this.fullPath() + "] has a total value count exceeding the allowed maximum value of 9223372036854775807");
            }
            double sum = this.validateOrEstimateSum(parsedHistogram, subParser);
            double min = this.validateOrEstimateMin(parsedHistogram, subParser);
            double max = this.validateOrEstimateMax(parsedHistogram, subParser);
            HistogramDocValueFields docValues = ExponentialHistogramFieldMapper.buildDocValueFields(this.fullPath(), parsedHistogram.scale(), parsedHistogram.negativeBuckets(), parsedHistogram.positiveBuckets(), parsedHistogram.zeroThreshold(), totalValueCount, sum, min, max);
            docValues.addToDoc(context.doc());
        }
        catch (Exception ex) {
            if (!((Boolean)this.ignoreMalformed.value()).booleanValue()) {
                throw new DocumentParsingException(context.parser().getTokenLocation(), "failed to parse field [" + this.fieldType().name() + "] of type [" + this.fieldType().typeName() + "]", ex);
            }
            if (subParser != null) {
                subParser.close();
            } else if (shouldStoreMalformedDataForSyntheticSource) {
                malformedDataForSyntheticSource = XContentBuilder.builder((XContent)context.parser().contentType().xContent()).copyCurrentStructure(context.parser());
            }
            if (malformedDataForSyntheticSource != null) {
                context.doc().add((IndexableField)IgnoreMalformedStoredValues.storedField((String)this.fullPath(), malformedDataForSyntheticSource));
            }
            context.addIgnoredField(this.fieldType().name());
        }
        context.path().remove();
    }

    public static HistogramDocValueFields buildDocValueFields(String fieldName, int scale, List<IndexWithCount> negativeBuckets, List<IndexWithCount> positiveBuckets, double zeroThreshold, long totalValueCount, double sum, double min, double max) throws IOException {
        BytesStreamOutput histogramBytesOutput = new BytesStreamOutput();
        CompressedExponentialHistogram.writeHistogramBytes((OutputStream)histogramBytesOutput, (int)scale, (BucketIterator)IndexWithCount.asBuckets((int)scale, negativeBuckets).iterator(), (BucketIterator)IndexWithCount.asBuckets((int)scale, positiveBuckets).iterator());
        BytesRef histoBytes = histogramBytesOutput.bytes().toBytesRef();
        BinaryDocValuesField histoField = new BinaryDocValuesField(fieldName, histoBytes);
        long thresholdAsLong = NumericUtils.doubleToSortableLong((double)zeroThreshold);
        NumericDocValuesField zeroThresholdField = new NumericDocValuesField(ExponentialHistogramFieldMapper.zeroThresholdSubFieldName(fieldName), thresholdAsLong);
        NumericDocValuesField valuesCountField = new NumericDocValuesField(ExponentialHistogramFieldMapper.valuesCountSubFieldName(fieldName), totalValueCount);
        NumericDocValuesField sumField = null;
        if (totalValueCount > 0L) {
            sumField = new NumericDocValuesField(ExponentialHistogramFieldMapper.valuesSumSubFieldName(fieldName), NumericUtils.doubleToSortableLong((double)sum));
        } else assert (sum == 0.0);
        NumericDocValuesField minField = null;
        if (!Double.isNaN(min)) {
            minField = new NumericDocValuesField(ExponentialHistogramFieldMapper.valuesMinSubFieldName(fieldName), NumericUtils.doubleToSortableLong((double)min));
        }
        NumericDocValuesField maxField = null;
        if (!Double.isNaN(max)) {
            maxField = new NumericDocValuesField(ExponentialHistogramFieldMapper.valuesMaxSubFieldName(fieldName), NumericUtils.doubleToSortableLong((double)max));
        }
        HistogramDocValueFields docValues = new HistogramDocValueFields(histoField, zeroThresholdField, valuesCountField, sumField, minField, maxField);
        return docValues;
    }

    private static boolean isEmpty(ExponentialHistogramParser.ParsedExponentialHistogram histogram) {
        return histogram.positiveBuckets().isEmpty() && histogram.negativeBuckets().isEmpty() && histogram.zeroCount() == 0L;
    }

    private double validateOrEstimateSum(ExponentialHistogramParser.ParsedExponentialHistogram histogram, XContentSubParser subParser) {
        if (histogram.sum() == null) {
            return ExponentialHistogramUtils.estimateSum((BucketIterator)IndexWithCount.asBuckets((int)histogram.scale(), (List)histogram.negativeBuckets()).iterator(), (BucketIterator)IndexWithCount.asBuckets((int)histogram.scale(), (List)histogram.positiveBuckets()).iterator());
        }
        if (ExponentialHistogramFieldMapper.isEmpty(histogram) && histogram.sum() != 0.0) {
            throw new DocumentParsingException(subParser.getTokenLocation(), "error parsing field [" + this.fullPath() + "], sum field must be zero if the histogram is empty, but got " + histogram.sum());
        }
        return histogram.sum();
    }

    private double validateOrEstimateMin(ExponentialHistogramParser.ParsedExponentialHistogram histogram, XContentSubParser subParser) {
        if (histogram.min() == null) {
            OptionalDouble estimatedMin = ExponentialHistogramUtils.estimateMin((ZeroBucket)ZeroBucket.create((double)histogram.zeroThreshold(), (long)histogram.zeroCount()), (ExponentialHistogram.Buckets)IndexWithCount.asBuckets((int)histogram.scale(), (List)histogram.negativeBuckets()), (ExponentialHistogram.Buckets)IndexWithCount.asBuckets((int)histogram.scale(), (List)histogram.positiveBuckets()));
            return estimatedMin.isPresent() ? estimatedMin.getAsDouble() : Double.NaN;
        }
        if (ExponentialHistogramFieldMapper.isEmpty(histogram)) {
            throw new DocumentParsingException(subParser.getTokenLocation(), "error parsing field [" + this.fullPath() + "], min field must be null if the histogram is empty, but got " + histogram.min());
        }
        return histogram.min();
    }

    private double validateOrEstimateMax(ExponentialHistogramParser.ParsedExponentialHistogram histogram, XContentSubParser subParser) {
        if (histogram.max() == null) {
            OptionalDouble estimatedMax = ExponentialHistogramUtils.estimateMax((ZeroBucket)ZeroBucket.create((double)histogram.zeroThreshold(), (long)histogram.zeroCount()), (ExponentialHistogram.Buckets)IndexWithCount.asBuckets((int)histogram.scale(), (List)histogram.negativeBuckets()), (ExponentialHistogram.Buckets)IndexWithCount.asBuckets((int)histogram.scale(), (List)histogram.positiveBuckets()));
            return estimatedMax.isPresent() ? estimatedMax.getAsDouble() : Double.NaN;
        }
        if (ExponentialHistogramFieldMapper.isEmpty(histogram)) {
            throw new DocumentParsingException(subParser.getTokenLocation(), "error parsing field [" + this.fullPath() + "], max field must be null if the histogram is empty, but got " + histogram.max());
        }
        return histogram.max();
    }

    private static long getTotalValueCount(ExponentialHistogramParser.ParsedExponentialHistogram histogram) {
        long totalValueCount = histogram.zeroCount();
        for (IndexWithCount bucket : histogram.positiveBuckets()) {
            totalValueCount = Math.addExact(totalValueCount, bucket.count());
        }
        for (IndexWithCount bucket : histogram.negativeBuckets()) {
            totalValueCount = Math.addExact(totalValueCount, bucket.count());
        }
        return totalValueCount;
    }

    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        return new FieldMapper.SyntheticSourceSupport.Native(() -> new CompositeSyntheticFieldLoader(this.leafName(), this.fullPath(), new CompositeSyntheticFieldLoader.Layer[]{new ExponentialHistogramSyntheticFieldLoader(), new CompositeSyntheticFieldLoader.MalformedValuesLayer(this.fullPath())}));
    }

    static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        private final FieldMapper.Parameter<Explicit<Boolean>> coerce;
        private final FieldMapper.Parameter<TimeSeriesParams.MetricType> metric;

        Builder(String name, boolean ignoreMalformedByDefault, boolean coerceByDefault) {
            super(name);
            this.ignoreMalformed = FieldMapper.Parameter.explicitBoolParam((String)"ignore_malformed", (boolean)true, m -> ExponentialHistogramFieldMapper.toType((FieldMapper)m).ignoreMalformed, (boolean)ignoreMalformedByDefault);
            this.coerce = FieldMapper.Parameter.explicitBoolParam((String)"coerce", (boolean)true, m -> ExponentialHistogramFieldMapper.toType((FieldMapper)m).coerce, (boolean)coerceByDefault);
            this.metric = TimeSeriesParams.metricParam(m -> ExponentialHistogramFieldMapper.toType((FieldMapper)m).metricType, (TimeSeriesParams.MetricType[])new TimeSeriesParams.MetricType[]{TimeSeriesParams.MetricType.HISTOGRAM});
        }

        public Builder metric(TimeSeriesParams.MetricType metric) {
            this.metric.setValue((Object)metric);
            return this;
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.ignoreMalformed, this.coerce, this.meta, this.metric};
        }

        public ExponentialHistogramFieldMapper build(MapperBuilderContext context) {
            return new ExponentialHistogramFieldMapper(this.leafName(), new ExponentialHistogramFieldType(context.buildFullName(this.leafName()), (Map)this.meta.getValue(), (TimeSeriesParams.MetricType)this.metric.getValue()), this.builderParams((Mapper.Builder)this, context), this);
        }
    }

    public record HistogramDocValueFields(BinaryDocValuesField histo, NumericDocValuesField zeroThreshold, NumericDocValuesField valuesCount, @Nullable NumericDocValuesField sumField, @Nullable NumericDocValuesField minField, @Nullable NumericDocValuesField maxField) {
        public void addToDoc(LuceneDocument doc) {
            doc.addWithKey((Object)this.histo.name(), (IndexableField)this.histo);
            doc.add((IndexableField)this.zeroThreshold);
            doc.add((IndexableField)this.valuesCount);
            if (this.sumField != null) {
                doc.add((IndexableField)this.sumField);
            }
            if (this.minField != null) {
                doc.add((IndexableField)this.minField);
            }
            if (this.maxField != null) {
                doc.add((IndexableField)this.maxField);
            }
        }

        public List<IndexableField> fieldsAsList() {
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
            fields.add((IndexableField)this.histo);
            fields.add((IndexableField)this.zeroThreshold);
            fields.add((IndexableField)this.valuesCount);
            if (this.sumField != null) {
                fields.add((IndexableField)this.sumField);
            }
            if (this.minField != null) {
                fields.add((IndexableField)this.minField);
            }
            if (this.maxField != null) {
                fields.add((IndexableField)this.maxField);
            }
            return fields;
        }
    }

    private class ExponentialHistogramSyntheticFieldLoader
    implements CompositeSyntheticFieldLoader.DocValuesLayer {
        @Nullable
        private ExponentialHistogram currentHistogram;

        private ExponentialHistogramSyntheticFieldLoader() {
        }

        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
            DocValuesReader histogramReader = new DocValuesReader(leafReader, ExponentialHistogramFieldMapper.this.fullPath());
            if (!histogramReader.hasAnyValues()) {
                return null;
            }
            return docId -> {
                if (histogramReader.advanceExact(docId)) {
                    this.currentHistogram = histogramReader.histogramValue();
                    return true;
                }
                this.currentHistogram = null;
                return false;
            };
        }

        public boolean hasValue() {
            return this.currentHistogram != null;
        }

        public void write(XContentBuilder b) throws IOException {
            if (this.currentHistogram == null) {
                return;
            }
            ExponentialHistogramXContent.serialize((XContentBuilder)b, (ExponentialHistogram)this.currentHistogram);
        }

        public String fieldName() {
            return ExponentialHistogramFieldMapper.this.fullPath();
        }

        public long valueCount() {
            return this.currentHistogram != null ? 1L : 0L;
        }
    }

    private static class DocValuesReader
    implements ExponentialHistogramValuesReader {
        private final BinaryDocValues histoDocValues;
        private final NumericDocValues zeroThresholds;
        private final NumericDocValues valueCounts;
        private final NumericDocValues valueSums;
        private final NumericDocValues valueMinima;
        private final NumericDocValues valueMaxima;
        private int currentDocId = -1;
        private final CompressedExponentialHistogram tempHistogram = new CompressedExponentialHistogram();

        DocValuesReader(LeafReader leafReader, String fullPath) throws IOException {
            this.histoDocValues = leafReader.getBinaryDocValues(fullPath);
            this.zeroThresholds = leafReader.getNumericDocValues(ExponentialHistogramFieldMapper.zeroThresholdSubFieldName(fullPath));
            this.valueCounts = leafReader.getNumericDocValues(ExponentialHistogramFieldMapper.valuesCountSubFieldName(fullPath));
            this.valueSums = leafReader.getNumericDocValues(ExponentialHistogramFieldMapper.valuesSumSubFieldName(fullPath));
            this.valueMinima = leafReader.getNumericDocValues(ExponentialHistogramFieldMapper.valuesMinSubFieldName(fullPath));
            this.valueMaxima = leafReader.getNumericDocValues(ExponentialHistogramFieldMapper.valuesMaxSubFieldName(fullPath));
        }

        boolean hasAnyValues() {
            return this.valueCounts != null;
        }

        @Override
        public boolean advanceExact(int docId) throws IOException {
            boolean isPresent = this.valueCounts != null && this.valueCounts.advanceExact(docId);
            this.currentDocId = isPresent ? docId : -1;
            return isPresent;
        }

        @Override
        public ExponentialHistogram histogramValue() throws IOException {
            double valueSum;
            if (this.currentDocId == -1) {
                throw new IllegalStateException("No histogram present for current document");
            }
            boolean histoPresent = this.histoDocValues.advanceExact(this.currentDocId);
            boolean zeroThresholdPresent = this.zeroThresholds.advanceExact(this.currentDocId);
            assert (zeroThresholdPresent && histoPresent);
            BytesRef encodedHistogram = this.histoDocValues.binaryValue();
            double zeroThreshold = NumericUtils.sortableLongToDouble((long)this.zeroThresholds.longValue());
            long valueCount = this.valueCounts.longValue();
            if (valueCount > 0L) {
                boolean valueSumsPresent = this.valueSums.advanceExact(this.currentDocId);
                assert (valueSumsPresent);
                valueSum = NumericUtils.sortableLongToDouble((long)this.valueSums.longValue());
            } else {
                valueSum = 0.0;
            }
            double valueMin = this.valueMinima != null && this.valueMinima.advanceExact(this.currentDocId) ? NumericUtils.sortableLongToDouble((long)this.valueMinima.longValue()) : Double.NaN;
            double valueMax = this.valueMaxima != null && this.valueMaxima.advanceExact(this.currentDocId) ? NumericUtils.sortableLongToDouble((long)this.valueMaxima.longValue()) : Double.NaN;
            this.tempHistogram.reset(zeroThreshold, valueCount, valueSum, valueMin, valueMax, encodedHistogram);
            return this.tempHistogram;
        }

        @Override
        public long valuesCountValue() throws IOException {
            return this.valueCounts.longValue();
        }

        @Override
        public double sumValue() throws IOException {
            if (this.currentDocId == -1) {
                throw new IllegalStateException("No histogram present for current document");
            }
            if (this.valueSums == null || !this.valueSums.advanceExact(this.currentDocId)) {
                return 0.0;
            }
            return NumericUtils.sortableLongToDouble((long)this.valueSums.longValue());
        }
    }

    public static final class ExponentialHistogramFieldType
    extends MappedFieldType {
        private final TimeSeriesParams.MetricType metricType;

        public ExponentialHistogramFieldType(String name, Map<String, String> meta, TimeSeriesParams.MetricType metricType) {
            super(name, IndexType.docValuesOnly(), false, meta);
            this.metricType = metricType;
        }

        public String typeName() {
            return ExponentialHistogramFieldMapper.CONTENT_TYPE;
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.identity((String)this.name(), (SearchExecutionContext)context, (String)format);
        }

        public boolean isSearchable() {
            return false;
        }

        public boolean isAggregatable() {
            return true;
        }

        public TimeSeriesParams.MetricType getMetricType() {
            return this.metricType;
        }

        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            return (cache, breakerService) -> new IndexExponentialHistogramFieldData(this, this.name()){

                public LeafExponentialHistogramFieldData load(final LeafReaderContext context) {
                    return new LeafExponentialHistogramFieldData(){

                        @Override
                        public ExponentialHistogramValuesReader getHistogramValues() throws IOException {
                            return new DocValuesReader(context.reader(), fieldName);
                        }

                        public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
                            throw new UnsupportedOperationException("The [exponential_histogram] field does not support scripts");
                        }

                        public SortedBinaryDocValues getBytesValues() {
                            throw new UnsupportedOperationException("String representation of doc values for [exponential_histogram] fields is not supported");
                        }

                        public FormattedDocValues getFormattedValues(DocValueFormat format) {
                            return ExponentialHistogramFieldMapper.createFormattedDocValues(context.reader(), fieldName);
                        }

                        public long ramBytesUsed() {
                            return 0L;
                        }
                    };
                }

                public LeafExponentialHistogramFieldData loadDirect(LeafReaderContext context) throws Exception {
                    return this.load(context);
                }

                public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
                    throw new IllegalArgumentException("can't sort on the [exponential_histogram] field");
                }

                public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
                    throw new IllegalArgumentException("can't sort on the [exponential_histogram] field");
                }
            };
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("[exponential_histogram] field do not support searching, use dedicated aggregations instead: [" + this.name() + "]");
        }

        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            final DoublesBlockLoader minimaLoader = new DoublesBlockLoader(ExponentialHistogramFieldMapper.valuesMinSubFieldName(this.name()), NumericUtils::sortableLongToDouble);
            final DoublesBlockLoader maximaLoader = new DoublesBlockLoader(ExponentialHistogramFieldMapper.valuesMaxSubFieldName(this.name()), NumericUtils::sortableLongToDouble);
            final DoublesBlockLoader sumsLoader = new DoublesBlockLoader(ExponentialHistogramFieldMapper.valuesSumSubFieldName(this.name()), NumericUtils::sortableLongToDouble);
            final DoublesBlockLoader valueCountsLoader = new DoublesBlockLoader(ExponentialHistogramFieldMapper.valuesCountSubFieldName(this.name()), longVal -> longVal);
            final DoublesBlockLoader zeroThresholdsLoader = new DoublesBlockLoader(ExponentialHistogramFieldMapper.zeroThresholdSubFieldName(this.name()), NumericUtils::sortableLongToDouble);
            final BytesRefsFromBinaryBlockLoader bytesLoader = new BytesRefsFromBinaryBlockLoader(this.name());
            return new BlockDocValuesReader.DocValuesBlockLoader(this){

                public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
                    return factory.exponentialHistogramBlockBuilder(expectedCount);
                }

                public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
                    final BlockLoader.AllReader bytesReader = bytesLoader.reader(context);
                    final BlockLoader.AllReader minimaReader = minimaLoader.reader(context);
                    final BlockLoader.AllReader maximaReader = maximaLoader.reader(context);
                    final BlockLoader.AllReader sumsReader = sumsLoader.reader(context);
                    final BlockLoader.AllReader valueCountsReader = valueCountsLoader.reader(context);
                    final BlockLoader.AllReader zeroThresholdsReader = zeroThresholdsLoader.reader(context);
                    return new BlockLoader.AllReader(){

                        public boolean canReuse(int startingDocID) {
                            return minimaReader.canReuse(startingDocID) && maximaReader.canReuse(startingDocID) && sumsReader.canReuse(startingDocID) && valueCountsReader.canReuse(startingDocID) && zeroThresholdsReader.canReuse(startingDocID) && bytesReader.canReuse(startingDocID);
                        }

                        public String toString() {
                            return "BlockDocValuesReader.ExponentialHistogram";
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
                            BlockLoader.Block minima = null;
                            BlockLoader.Block maxima = null;
                            BlockLoader.Block sums = null;
                            BlockLoader.Block valueCounts = null;
                            BlockLoader.Block zeroThresholds = null;
                            BlockLoader.Block encodedBytes = null;
                            boolean success = false;
                            try {
                                minima = minimaReader.read(factory, docs, offset, nullsFiltered);
                                maxima = maximaReader.read(factory, docs, offset, nullsFiltered);
                                sums = sumsReader.read(factory, docs, offset, nullsFiltered);
                                valueCounts = valueCountsReader.read(factory, docs, offset, nullsFiltered);
                                zeroThresholds = zeroThresholdsReader.read(factory, docs, offset, nullsFiltered);
                                encodedBytes = bytesReader.read(factory, docs, offset, nullsFiltered);
                                return factory.buildExponentialHistogramBlockDirect(minima, maxima, sums, valueCounts, zeroThresholds, encodedBytes);
                            }
                            catch (Throwable throwable) {
                                if (success) throw throwable;
                                Releasables.close((Releasable[])new Releasable[]{minima, maxima, sums, valueCounts, zeroThresholds, encodedBytes});
                                throw throwable;
                            }
                        }

                        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
                            BlockLoader.ExponentialHistogramBuilder histogramBuilder = (BlockLoader.ExponentialHistogramBuilder)builder;
                            minimaReader.read(docId, storedFields, (BlockLoader.Builder)histogramBuilder.minima());
                            maximaReader.read(docId, storedFields, (BlockLoader.Builder)histogramBuilder.maxima());
                            sumsReader.read(docId, storedFields, (BlockLoader.Builder)histogramBuilder.sums());
                            valueCountsReader.read(docId, storedFields, (BlockLoader.Builder)histogramBuilder.valueCounts());
                            zeroThresholdsReader.read(docId, storedFields, (BlockLoader.Builder)histogramBuilder.zeroThresholds());
                            bytesReader.read(docId, storedFields, (BlockLoader.Builder)histogramBuilder.encodedHistograms());
                        }
                    };
                }
            };
        }
    }
}

