/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openshiftai.rerank;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.openshiftai.OpenShiftAiServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class OpenShiftAiRerankServiceSettings
extends OpenShiftAiServiceSettings {
    public static final String NAME = "openshift_ai_rerank_service_settings";

    public static OpenShiftAiRerankServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        return OpenShiftAiRerankServiceSettings.fromMap(map, context, commonServiceSettings -> new OpenShiftAiRerankServiceSettings(commonServiceSettings.model(), commonServiceSettings.uri(), commonServiceSettings.rateLimitSettings()));
    }

    public OpenShiftAiRerankServiceSettings(StreamInput in) throws IOException {
        super(in);
    }

    public OpenShiftAiRerankServiceSettings(@Nullable String modelId, URI uri, @Nullable RateLimitSettings rateLimitSettings) {
        super(modelId, uri, rateLimitSettings);
    }

    public OpenShiftAiRerankServiceSettings(@Nullable String modelId, String url, @Nullable RateLimitSettings rateLimitSettings) {
        this(modelId, ServiceUtils.createUri(url), rateLimitSettings);
    }

    public String getWriteableName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenShiftAiRerankServiceSettings that = (OpenShiftAiRerankServiceSettings)o;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.uri, that.uri) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.uri, this.rateLimitSettings);
    }
}

