/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface.request.rerank;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceAccount;
import org.elasticsearch.xpack.inference.services.huggingface.request.rerank.HuggingFaceRerankRequestEntity;
import org.elasticsearch.xpack.inference.services.huggingface.rerank.HuggingFaceRerankModel;

public class HuggingFaceRerankRequest
implements Request {
    private final HuggingFaceAccount account;
    private final String query;
    private final List<String> input;
    private final Boolean returnDocuments;
    private final Integer topN;
    private final HuggingFaceRerankModel model;

    public HuggingFaceRerankRequest(String query, List<String> input, @Nullable Boolean returnDocuments, @Nullable Integer topN, HuggingFaceRerankModel model) {
        Objects.requireNonNull(model);
        this.account = HuggingFaceAccount.of(model);
        this.input = Objects.requireNonNull(input);
        this.query = Objects.requireNonNull(query);
        this.returnDocuments = returnDocuments;
        this.topN = topN;
        this.model = model;
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.account.uri());
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)new HuggingFaceRerankRequestEntity(this.query, this.input, this.returnDocuments, this.getTopN(), this.model.getTaskSettings())).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader("Content-Type", XContentType.JSON.mediaTypeWithoutParameters());
        this.decorateWithAuth(httpPost);
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    void decorateWithAuth(HttpPost httpPost) {
        httpPost.setHeader(RequestUtils.createAuthBearerHeader(this.model.apiKey()));
    }

    @Override
    public String getInferenceEntityId() {
        return this.model.getInferenceEntityId();
    }

    @Override
    public URI getURI() {
        return this.account.uri();
    }

    public Integer getTopN() {
        return this.topN != null ? this.topN : this.model.getTaskSettings().getTopNDocumentsOnly();
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }
}

