/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.ccm;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.inference.InferenceFeatures;
import org.elasticsearch.xpack.inference.common.BroadcastMessageAction;
import org.elasticsearch.xpack.inference.services.elastic.ccm.CCMModel;
import org.elasticsearch.xpack.inference.services.elastic.ccm.CCMPersistentStorageService;

public class CCMCache {
    private static final Setting<Integer> INFERENCE_CCM_CACHE_WEIGHT = Setting.intSetting((String)"xpack.inference.ccm.cache.weight", (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<TimeValue> INFERENCE_CCM_CACHE_EXPIRY = Setting.timeSetting((String)"xpack.inference.ccm.cache.expiry_time", (TimeValue)TimeValue.timeValueMinutes((long)15L), (TimeValue)TimeValue.timeValueMinutes((long)1L), (TimeValue)TimeValue.timeValueHours((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(CCMCache.class);
    private static final Cache.Stats EMPTY = new Cache.Stats(0L, 0L, 0L);
    private final CCMPersistentStorageService ccmPersistentStorageService;
    private final Cache<ProjectId, CCMModelEntry> cache;
    private final ClusterService clusterService;
    private final FeatureService featureService;
    private final ProjectResolver projectResolver;
    private final Client client;

    public static Collection<? extends Setting<?>> getSettingsDefinitions() {
        return List.of(INFERENCE_CCM_CACHE_WEIGHT, INFERENCE_CCM_CACHE_EXPIRY);
    }

    public CCMCache(CCMPersistentStorageService ccmPersistentStorageService, ClusterService clusterService, Settings settings, FeatureService featureService, ProjectResolver projectResolver, Client client) {
        this.ccmPersistentStorageService = ccmPersistentStorageService;
        this.cache = CacheBuilder.builder().setMaximumWeight((long)((Integer)INFERENCE_CCM_CACHE_WEIGHT.get(settings)).intValue()).setExpireAfterWrite((TimeValue)INFERENCE_CCM_CACHE_EXPIRY.get(settings)).build();
        this.clusterService = clusterService;
        this.featureService = featureService;
        this.projectResolver = projectResolver;
        this.client = client;
    }

    public void get(ActionListener<CCMModel> listener) {
        ProjectId projectId = this.projectResolver.getProjectId();
        CCMModelEntry cachedEntry = this.getCacheEntry(projectId);
        if (cachedEntry != null && cachedEntry.enabled()) {
            listener.onResponse((Object)cachedEntry.ccmModel());
        } else {
            this.ccmPersistentStorageService.get((ActionListener<CCMModel>)ActionListener.wrap(ccmModel -> {
                this.putEnabledEntry(projectId, (CCMModel)ccmModel);
                listener.onResponse(ccmModel);
            }, e -> {
                if (e instanceof ResourceNotFoundException) {
                    this.putDisabledEntry(projectId);
                }
                listener.onFailure(e);
            }));
        }
    }

    private CCMModelEntry getCacheEntry(ProjectId projectId) {
        return this.cacheEnabled() ? (CCMModelEntry)this.cache.get((Object)projectId) : null;
    }

    private boolean cacheEnabled() {
        ClusterState state = this.clusterService.state();
        return state.clusterRecovered() && this.featureService.clusterHasFeature(state, InferenceFeatures.INFERENCE_CCM_CACHE);
    }

    private void putEnabledEntry(ProjectId projectId, CCMModel ccmModel) {
        if (this.cacheEnabled()) {
            this.cache.put((Object)projectId, (Object)CCMModelEntry.enabled(ccmModel));
        }
    }

    private void putDisabledEntry(ProjectId projectId) {
        if (this.cacheEnabled()) {
            this.cache.put((Object)projectId, (Object)CCMModelEntry.DISABLED);
        }
    }

    public void isEnabled(ActionListener<Boolean> listener) {
        ProjectId projectId = this.projectResolver.getProjectId();
        CCMModelEntry cachedEntry = this.getCacheEntry(projectId);
        if (cachedEntry != null) {
            listener.onResponse((Object)cachedEntry.enabled());
        } else {
            this.ccmPersistentStorageService.get((ActionListener<CCMModel>)ActionListener.wrap(ccmModel -> {
                this.putEnabledEntry(projectId, (CCMModel)ccmModel);
                listener.onResponse((Object)true);
            }, e -> {
                if (e instanceof ResourceNotFoundException) {
                    this.putDisabledEntry(projectId);
                    listener.onResponse((Object)false);
                } else {
                    listener.onFailure(e);
                }
            }));
        }
    }

    public void invalidate(ActionListener<Void> listener) {
        if (this.cacheEnabled()) {
            this.client.execute(ClearCCMCacheAction.INSTANCE, ClearCCMCacheAction.request(ClearCCMMessage.INSTANCE, null), ActionListener.wrap(ack -> {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = () -> ((ProjectResolver)this.projectResolver).getProjectId();
                logger.debug("Successfully refreshed inference CCM cache for project {}.", supplierArray);
                listener.onResponse((Object)null);
            }, e -> {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = () -> ((ProjectResolver)this.projectResolver).getProjectId();
                logger.atDebug().withThrowable((Throwable)e).log("Failed to refresh inference CCM cache for project {}.", supplierArray);
                listener.onFailure(e);
            }));
        }
    }

    private void invalidate(ProjectId projectId) {
        if (this.cacheEnabled()) {
            Iterator cacheKeys = this.cache.keys().iterator();
            while (cacheKeys.hasNext()) {
                if (!((ProjectId)cacheKeys.next()).equals((Object)projectId)) continue;
                cacheKeys.remove();
            }
        }
    }

    public Cache.Stats stats() {
        return this.cacheEnabled() ? this.cache.stats() : EMPTY;
    }

    public int cacheCount() {
        return this.cacheEnabled() ? this.cache.count() : 0;
    }

    private record CCMModelEntry(boolean enabled, @Nullable CCMModel ccmModel) {
        private static final CCMModelEntry DISABLED = new CCMModelEntry(false, null);

        private static CCMModelEntry enabled(CCMModel ccmModel) {
            return new CCMModelEntry(true, Objects.requireNonNull(ccmModel));
        }
    }

    public static class ClearCCMCacheAction
    extends BroadcastMessageAction<ClearCCMMessage> {
        private static final String NAME = "cluster:internal/xpack/inference/clear_inference_ccm_cache";
        public static final ActionType<BroadcastMessageAction.Response> INSTANCE = new ActionType("cluster:internal/xpack/inference/clear_inference_ccm_cache");
        private final ProjectResolver projectResolver;
        private final CCMCache ccmCache;

        @Inject
        public ClearCCMCacheAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, ProjectResolver projectResolver, CCMCache ccmCache) {
            super(NAME, clusterService, transportService, actionFilters, in -> ClearCCMMessage.INSTANCE);
            this.projectResolver = projectResolver;
            this.ccmCache = ccmCache;
        }

        @Override
        protected void receiveMessage(ClearCCMMessage clearCCMMessage) {
            this.ccmCache.invalidate(this.projectResolver.getProjectId());
        }
    }

    public record ClearCCMMessage() implements Writeable
    {
        private static final ClearCCMMessage INSTANCE = new ClearCCMMessage();

        public void writeTo(StreamOutput out) throws IOException {
        }
    }
}

