/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.allocation.decider;

import org.elasticsearch.blobcache.shared.SharedBlobCacheService;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.xpack.searchablesnapshots.cache.shared.FrozenCacheInfoService;

public class HasFrozenCacheAllocationDecider
extends AllocationDecider {
    private static final String NAME = "has_frozen_cache";
    private static final Decision STILL_FETCHING = Decision.single((Decision.Type)Decision.Type.THROTTLE, (String)"has_frozen_cache", (String)("value of [" + SharedBlobCacheService.SHARED_CACHE_SIZE_SETTING.getKey() + "] on this node is not known yet"), (Object[])new Object[0]);
    private static final Decision NO_STILL_FETCHING = Decision.single((Decision.Type)Decision.Type.NO, (String)"has_frozen_cache", (String)("Shard movement is not allowed in simulation when value of [" + SharedBlobCacheService.SHARED_CACHE_SIZE_SETTING.getKey() + "] on this node is not known"), (Object[])new Object[0]);
    private static final Decision HAS_FROZEN_CACHE = Decision.single((Decision.Type)Decision.Type.YES, (String)"has_frozen_cache", (String)"this node has a searchable snapshot shared cache", (Object[])new Object[0]);
    private static final Decision NO_FROZEN_CACHE = Decision.single((Decision.Type)Decision.Type.NO, (String)"has_frozen_cache", (String)("node setting [" + SharedBlobCacheService.SHARED_CACHE_SIZE_SETTING.getKey() + "] is set to zero, so shards of partially mounted indices cannot be allocated to this node"), (Object[])new Object[0]);
    private static final Decision UNKNOWN_FROZEN_CACHE = Decision.single((Decision.Type)Decision.Type.NO, (String)"has_frozen_cache", (String)"there was an error fetching the searchable snapshot shared cache state from this node", (Object[])new Object[0]);
    private static final Decision NO_UNKNOWN_NODE = Decision.single((Decision.Type)Decision.Type.NO, (String)"has_frozen_cache", (String)"this node is unknown to the searchable snapshot shared cache state", (Object[])new Object[0]);
    private final FrozenCacheInfoService frozenCacheService;

    public HasFrozenCacheAllocationDecider(FrozenCacheInfoService frozenCacheService) {
        this.frozenCacheService = frozenCacheService;
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocateToNode(allocation.metadata().indexMetadata(shardRouting.index()), node.node(), allocation);
    }

    public Decision canRemain(IndexMetadata indexMetadata, ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocateToNode(indexMetadata, node.node(), allocation);
    }

    public Decision canAllocate(IndexMetadata indexMetadata, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocateToNode(indexMetadata, node.node(), allocation);
    }

    public Decision shouldAutoExpandToNode(IndexMetadata indexMetadata, DiscoveryNode node, RoutingAllocation allocation) {
        return this.canAllocateToNode(indexMetadata, node, allocation);
    }

    Decision canAllocateToNode(IndexMetadata indexMetadata, DiscoveryNode discoveryNode, RoutingAllocation allocation) {
        if (!indexMetadata.isPartialSearchableSnapshot()) {
            return Decision.ALWAYS;
        }
        return switch (this.frozenCacheService.getNodeState(discoveryNode)) {
            default -> throw new MatchException(null, null);
            case FrozenCacheInfoService.NodeState.HAS_CACHE -> HAS_FROZEN_CACHE;
            case FrozenCacheInfoService.NodeState.NO_CACHE -> NO_FROZEN_CACHE;
            case FrozenCacheInfoService.NodeState.FAILED -> UNKNOWN_FROZEN_CACHE;
            case FrozenCacheInfoService.NodeState.FETCHING -> {
                if (allocation.isSimulating()) {
                    yield NO_STILL_FETCHING;
                }
                yield STILL_FETCHING;
            }
            case FrozenCacheInfoService.NodeState.UNKNOWN -> NO_UNKNOWN_NODE;
        };
    }
}

