/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMin;

public final class ClampMinIntegerEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ClampMinIntegerEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator field;
    private final EvalOperator.ExpressionEvaluator min;
    private final DriverContext driverContext;
    private Warnings warnings;

    public ClampMinIntegerEvaluator(Source source, EvalOperator.ExpressionEvaluator field, EvalOperator.ExpressionEvaluator min, DriverContext driverContext) {
        this.source = source;
        this.field = field;
        this.min = min;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (IntBlock fieldBlock = (IntBlock)this.field.eval(page);){
            IntBlock intBlock;
            block20: {
                IntVector minVector;
                IntVector fieldVector;
                IntBlock minBlock;
                block18: {
                    IntBlock intBlock2;
                    block19: {
                        block16: {
                            IntBlock intBlock3;
                            block17: {
                                minBlock = (IntBlock)this.min.eval(page);
                                try {
                                    fieldVector = fieldBlock.asVector();
                                    if (fieldVector != null) break block16;
                                    intBlock3 = this.eval(page.getPositionCount(), fieldBlock, minBlock);
                                    if (minBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (minBlock != null) {
                                        try {
                                            minBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                minBlock.close();
                            }
                            return intBlock3;
                        }
                        minVector = minBlock.asVector();
                        if (minVector != null) break block18;
                        intBlock2 = this.eval(page.getPositionCount(), fieldBlock, minBlock);
                        if (minBlock == null) break block19;
                        minBlock.close();
                    }
                    return intBlock2;
                }
                intBlock = this.eval(page.getPositionCount(), fieldVector, minVector).asBlock();
                if (minBlock == null) break block20;
                minBlock.close();
            }
            return intBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.field.baseRamBytesUsed();
        return baseRamBytesUsed += this.min.baseRamBytesUsed();
    }

    public IntBlock eval(int positionCount, IntBlock fieldBlock, IntBlock minBlock) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            block13: for (int p = 0; p < positionCount; ++p) {
                switch (fieldBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                switch (minBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                int field = fieldBlock.getInt(fieldBlock.getFirstValueIndex(p));
                int min = minBlock.getInt(minBlock.getFirstValueIndex(p));
                result.appendInt(ClampMin.process(field, min));
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntVector eval(int positionCount, IntVector fieldVector, IntVector minVector) {
        try (IntVector.FixedBuilder result = this.driverContext.blockFactory().newIntVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int field = fieldVector.getInt(p);
                int min = minVector.getInt(p);
                result.appendInt(p, ClampMin.process(field, min));
            }
            IntVector intVector = result.build();
            return intVector;
        }
    }

    public String toString() {
        return "ClampMinIntegerEvaluator[field=" + String.valueOf(this.field) + ", min=" + String.valueOf(this.min) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.field, this.min});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;
        private final EvalOperator.ExpressionEvaluator.Factory min;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field, EvalOperator.ExpressionEvaluator.Factory min) {
            this.source = source;
            this.field = field;
            this.min = min;
        }

        public ClampMinIntegerEvaluator get(DriverContext context) {
            return new ClampMinIntegerEvaluator(this.source, this.field.get(context), this.min.get(context), context);
        }

        public String toString() {
            return "ClampMinIntegerEvaluator[field=" + String.valueOf(this.field) + ", min=" + String.valueOf(this.min) + "]";
        }
    }
}

