/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopIntLongAggregatorFunction;
import org.elasticsearch.compute.aggregation.TopIntLongGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopIntLongAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final int limit;
    private final boolean ascending;

    public TopIntLongAggregatorFunctionSupplier(int limit, boolean ascending) {
        this.limit = limit;
        this.ascending = ascending;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return TopIntLongAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return TopIntLongGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public TopIntLongAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return TopIntLongAggregatorFunction.create(driverContext, channels, this.limit, this.ascending);
    }

    @Override
    public TopIntLongGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return TopIntLongGroupingAggregatorFunction.create(channels, driverContext, this.limit, this.ascending);
    }

    @Override
    public String describe() {
        return "top_int of longs";
    }
}

