/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.ExponentialHistogramStates;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.HistogramMergeExponentialHistogramAggregator;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.ExponentialHistogramBlock;
import org.elasticsearch.compute.data.ExponentialHistogramScratch;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;

public final class HistogramMergeExponentialHistogramGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("value", ElementType.EXPONENTIAL_HISTOGRAM));
    private final ExponentialHistogramStates.GroupingState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;

    public HistogramMergeExponentialHistogramGroupingAggregatorFunction(List<Integer> channels, ExponentialHistogramStates.GroupingState state, DriverContext driverContext) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
    }

    public static HistogramMergeExponentialHistogramGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext) {
        return new HistogramMergeExponentialHistogramGroupingAggregatorFunction(channels, HistogramMergeExponentialHistogramAggregator.initGrouping(driverContext.bigArrays(), driverContext), driverContext);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        final ExponentialHistogramBlock valueBlock = (ExponentialHistogramBlock)page.getBlock(this.channels.get(0));
        this.maybeEnableGroupIdTracking(seenGroupIds, valueBlock);
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                HistogramMergeExponentialHistogramGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock);
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                HistogramMergeExponentialHistogramGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                HistogramMergeExponentialHistogramGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock);
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, ExponentialHistogramBlock valueBlock) {
        ExponentialHistogramScratch valueScratch = new ExponentialHistogramScratch();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || valueBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valueStart = valueBlock.getFirstValueIndex(valuesPosition);
                int valueEnd = valueStart + valueBlock.getValueCount(valuesPosition);
                for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                    ExponentialHistogram valueValue = valueBlock.getExponentialHistogram(valueOffset, valueScratch);
                    HistogramMergeExponentialHistogramAggregator.combine(this.state, groupId, valueValue);
                }
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object valueUncast = page.getBlock(this.channels.get(0));
        if (valueUncast.areAllValuesNull()) {
            return;
        }
        ExponentialHistogramBlock value = (ExponentialHistogramBlock)valueUncast;
        ExponentialHistogramScratch valueScratch = new ExponentialHistogramScratch();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                HistogramMergeExponentialHistogramAggregator.combineIntermediate(this.state, groupId, value.getExponentialHistogram(value.getFirstValueIndex(valuesPosition), valueScratch));
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, ExponentialHistogramBlock valueBlock) {
        ExponentialHistogramScratch valueScratch = new ExponentialHistogramScratch();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || valueBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valueStart = valueBlock.getFirstValueIndex(valuesPosition);
                int valueEnd = valueStart + valueBlock.getValueCount(valuesPosition);
                for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                    ExponentialHistogram valueValue = valueBlock.getExponentialHistogram(valueOffset, valueScratch);
                    HistogramMergeExponentialHistogramAggregator.combine(this.state, groupId, valueValue);
                }
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntBigArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object valueUncast = page.getBlock(this.channels.get(0));
        if (valueUncast.areAllValuesNull()) {
            return;
        }
        ExponentialHistogramBlock value = (ExponentialHistogramBlock)valueUncast;
        ExponentialHistogramScratch valueScratch = new ExponentialHistogramScratch();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                HistogramMergeExponentialHistogramAggregator.combineIntermediate(this.state, groupId, value.getExponentialHistogram(value.getFirstValueIndex(valuesPosition), valueScratch));
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, ExponentialHistogramBlock valueBlock) {
        ExponentialHistogramScratch valueScratch = new ExponentialHistogramScratch();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            if (valueBlock.isNull(valuesPosition)) continue;
            int groupId = groups.getInt(groupPosition);
            int valueStart = valueBlock.getFirstValueIndex(valuesPosition);
            int valueEnd = valueStart + valueBlock.getValueCount(valuesPosition);
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                ExponentialHistogram valueValue = valueBlock.getExponentialHistogram(valueOffset, valueScratch);
                HistogramMergeExponentialHistogramAggregator.combine(this.state, groupId, valueValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object valueUncast = page.getBlock(this.channels.get(0));
        if (valueUncast.areAllValuesNull()) {
            return;
        }
        ExponentialHistogramBlock value = (ExponentialHistogramBlock)valueUncast;
        ExponentialHistogramScratch valueScratch = new ExponentialHistogramScratch();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            int valuesPosition = groupPosition + positionOffset;
            HistogramMergeExponentialHistogramAggregator.combineIntermediate(this.state, groupId, value.getExponentialHistogram(value.getFirstValueIndex(valuesPosition), valueScratch));
        }
    }

    private void maybeEnableGroupIdTracking(SeenGroupIds seenGroupIds, ExponentialHistogramBlock valueBlock) {
        if (valueBlock.mayHaveNulls()) {
            this.state.enableGroupIdTracking(seenGroupIds);
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
        this.state.enableGroupIdTracking(seenGroupIds);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        blocks[offset] = HistogramMergeExponentialHistogramAggregator.evaluateFinal(this.state, selected, ctx);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

