/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.compute.aggregation.AbstractArrayState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.SimpleLinearRegressionWithTimeseries;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

class DerivDoubleAggregator {
    DerivDoubleAggregator() {
    }

    public static SimpleLinearRegressionWithTimeseries initSingle(DriverContext driverContext) {
        return new SimpleLinearRegressionWithTimeseries();
    }

    public static void combine(SimpleLinearRegressionWithTimeseries current, double value, long timestamp) {
        current.add(timestamp, value);
    }

    public static void combineIntermediate(SimpleLinearRegressionWithTimeseries state, long count, double sumVal, long sumTs, double sumTsVal, long sumTsSq) {
        state.count += count;
        state.sumVal += sumVal;
        state.sumTs += sumTs;
        state.sumTsVal += sumTsVal;
        state.sumTsSq += sumTsSq;
    }

    public static Block evaluateFinal(SimpleLinearRegressionWithTimeseries state, DriverContext driverContext) {
        BlockFactory blockFactory = driverContext.blockFactory();
        double slope = state.slope();
        if (Double.isNaN(slope)) {
            return blockFactory.newConstantNullBlock(1);
        }
        return blockFactory.newConstantDoubleBlockWith(slope, 1);
    }

    public static GroupingState initGrouping(DriverContext driverContext) {
        return new GroupingState(driverContext.bigArrays());
    }

    public static void combine(GroupingState state, int groupId, double value, long timestamp) {
        state.getAndGrow(groupId).add(timestamp, value);
    }

    public static void combineIntermediate(GroupingState state, int groupId, long count, double sumVal, long sumTs, double sumTsVal, long sumTsSq) {
        DerivDoubleAggregator.combineIntermediate(state.getAndGrow(groupId), count, sumVal, sumTs, sumTsVal, sumTsSq);
    }

    public static Block evaluateFinal(GroupingState state, IntVector selectedGroups, GroupingAggregatorEvaluationContext ctx) {
        try (DoubleBlock.Builder builder = ctx.driverContext().blockFactory().newDoubleBlockBuilder(selectedGroups.getPositionCount());){
            for (int i = 0; i < selectedGroups.getPositionCount(); ++i) {
                int groupId = selectedGroups.getInt(i);
                SimpleLinearRegressionWithTimeseries slr = state.get(groupId);
                if (slr == null) {
                    builder.appendNull();
                    continue;
                }
                double result = slr.slope();
                if (Double.isNaN(result)) {
                    builder.appendNull();
                    continue;
                }
                builder.appendDouble(result);
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    public static final class GroupingState
    extends AbstractArrayState {
        private ObjectArray<SimpleLinearRegressionWithTimeseries> states;

        GroupingState(BigArrays bigArrays) {
            super(bigArrays);
            this.states = bigArrays.newObjectArray(1L);
        }

        SimpleLinearRegressionWithTimeseries get(int groupId) {
            if ((long)groupId >= this.states.size()) {
                return null;
            }
            return (SimpleLinearRegressionWithTimeseries)this.states.get((long)groupId);
        }

        SimpleLinearRegressionWithTimeseries getAndGrow(int groupId) {
            SimpleLinearRegressionWithTimeseries slr;
            if ((long)groupId >= this.states.size()) {
                this.states = this.bigArrays.grow(this.states, (long)(groupId + 1));
            }
            if ((slr = (SimpleLinearRegressionWithTimeseries)this.states.get((long)groupId)) == null) {
                slr = new SimpleLinearRegressionWithTimeseries();
                this.states.set((long)groupId, (Object)slr);
            }
            return slr;
        }

        @Override
        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.states, () -> super.close()});
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            try (LongBlock.Builder countBuilder = driverContext.blockFactory().newLongBlockBuilder(selected.getPositionCount());
                 DoubleBlock.Builder sumValBuilder = driverContext.blockFactory().newDoubleBlockBuilder(selected.getPositionCount());
                 LongBlock.Builder sumTsBuilder = driverContext.blockFactory().newLongBlockBuilder(selected.getPositionCount());
                 DoubleBlock.Builder sumTsValBuilder = driverContext.blockFactory().newDoubleBlockBuilder(selected.getPositionCount());
                 LongBlock.Builder sumTsSqBuilder = driverContext.blockFactory().newLongBlockBuilder(selected.getPositionCount());){
                for (int i = 0; i < selected.getPositionCount(); ++i) {
                    int groupId = selected.getInt(i);
                    SimpleLinearRegressionWithTimeseries slr = this.get(groupId);
                    if (slr == null) {
                        countBuilder.appendNull();
                        sumValBuilder.appendNull();
                        sumTsBuilder.appendNull();
                        sumTsValBuilder.appendNull();
                        sumTsSqBuilder.appendNull();
                        continue;
                    }
                    countBuilder.appendLong(slr.count);
                    sumValBuilder.appendDouble(slr.sumVal);
                    sumTsBuilder.appendLong(slr.sumTs);
                    sumTsValBuilder.appendDouble(slr.sumTsVal);
                    sumTsSqBuilder.appendLong(slr.sumTsSq);
                }
                blocks[offset] = countBuilder.build();
                blocks[offset + 1] = sumValBuilder.build();
                blocks[offset + 2] = sumTsBuilder.build();
                blocks[offset + 3] = sumTsValBuilder.build();
                blocks[offset + 4] = sumTsSqBuilder.build();
            }
        }
    }
}

