/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openshiftai.request.rarank;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.services.openshiftai.request.rarank.OpenShiftAIRerankRequestEntity;
import org.elasticsearch.xpack.inference.services.openshiftai.rerank.OpenShiftAiRerankModel;

public record OpenShiftAiRerankRequest(String query, List<String> input, @Nullable Boolean returnDocuments, @Nullable Integer topN, OpenShiftAiRerankModel model) implements Request
{
    @Nullable
    private final Boolean returnDocuments;
    @Nullable
    private final Integer topN;

    public OpenShiftAiRerankRequest {
        Objects.requireNonNull(input);
        Objects.requireNonNull(query);
        Objects.requireNonNull(model);
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.getURI());
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)new OpenShiftAIRerankRequestEntity(this.model.getServiceSettings().modelId(), this.query, this.input, this.returnDocuments(), this.topN())).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader("Content-Type", XContentType.JSON.mediaTypeWithoutParameters());
        httpPost.setHeader(RequestUtils.createAuthBearerHeader(this.model.getSecretSettings().apiKey()));
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    @Override
    public String getInferenceEntityId() {
        return this.model.getInferenceEntityId();
    }

    @Override
    public URI getURI() {
        return this.model.getServiceSettings().uri();
    }

    public Integer topN() {
        return this.topN != null ? this.topN : this.model.getTaskSettings().getTopN();
    }

    public Boolean returnDocuments() {
        return this.returnDocuments != null ? this.returnDocuments : this.model.getTaskSettings().getReturnDocuments();
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }
}

