/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openshiftai.completion;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.openshiftai.OpenShiftAiServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class OpenShiftAiChatCompletionServiceSettings
extends OpenShiftAiServiceSettings {
    public static final String NAME = "openshift_ai_completion_service_settings";

    public static OpenShiftAiChatCompletionServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        return OpenShiftAiChatCompletionServiceSettings.fromMap(map, context, commonServiceSettings -> new OpenShiftAiChatCompletionServiceSettings(commonServiceSettings.model(), commonServiceSettings.uri(), commonServiceSettings.rateLimitSettings()));
    }

    public OpenShiftAiChatCompletionServiceSettings(StreamInput in) throws IOException {
        super(in);
    }

    public OpenShiftAiChatCompletionServiceSettings(@Nullable String modelId, URI uri, @Nullable RateLimitSettings rateLimitSettings) {
        super(modelId, uri, rateLimitSettings);
    }

    public OpenShiftAiChatCompletionServiceSettings(@Nullable String modelId, String url, @Nullable RateLimitSettings rateLimitSettings) {
        super(modelId, ServiceUtils.createUri(url), rateLimitSettings);
    }

    public String getWriteableName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenShiftAiChatCompletionServiceSettings that = (OpenShiftAiChatCompletionServiceSettings)o;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.uri, that.uri) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.uri, this.rateLimitSettings);
    }
}

