/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai.response;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.DenseEmbeddingFloatResults;
import org.elasticsearch.xpack.core.inference.results.EmbeddingFloatResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.request.Request;

public class OpenAiEmbeddingsResponseEntity {
    public static DenseEmbeddingFloatResults fromResponse(Request request, HttpResult response) throws IOException {
        try (XContentParser p = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response.body());){
            DenseEmbeddingFloatResults denseEmbeddingFloatResults = ((EmbeddingFloatResult)EmbeddingFloatResult.PARSER.apply(p, null)).toDenseEmbeddingFloatResults();
            return denseEmbeddingFloatResults;
        }
    }

    private OpenAiEmbeddingsResponseEntity() {
    }

    public record EmbeddingFloatResult(List<EmbeddingFloatResultEntry> embeddingResults) {
        public static final ConstructingObjectParser<EmbeddingFloatResult, Void> PARSER = new ConstructingObjectParser(EmbeddingFloatResult.class.getSimpleName(), true, args -> new EmbeddingFloatResult((List)args[0]));

        public DenseEmbeddingFloatResults toDenseEmbeddingFloatResults() {
            return new DenseEmbeddingFloatResults(this.embeddingResults.stream().map(entry -> EmbeddingFloatResults.Embedding.of(entry.embedding)).toList());
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> EmbeddingFloatResultEntry.PARSER.apply(arg_0, arg_1), new ParseField("data", new String[0]));
        }
    }

    public record EmbeddingFloatResultEntry(List<Float> embedding) {
        public static final ConstructingObjectParser<EmbeddingFloatResultEntry, Void> PARSER = new ConstructingObjectParser(EmbeddingFloatResultEntry.class.getSimpleName(), true, args -> new EmbeddingFloatResultEntry((List)args[0]));

        static {
            PARSER.declareFloatArray(ConstructingObjectParser.constructorArg(), new ParseField("embedding", new String[0]));
        }
    }
}

