/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.llama.embeddings;

import java.util.Map;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.EmptyTaskSettings;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.RateLimitGroupingModel;
import org.elasticsearch.xpack.inference.services.llama.LlamaModel;
import org.elasticsearch.xpack.inference.services.llama.action.LlamaActionVisitor;
import org.elasticsearch.xpack.inference.services.llama.embeddings.LlamaEmbeddingsServiceSettings;

public class LlamaEmbeddingsModel
extends LlamaModel {
    public LlamaEmbeddingsModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, ChunkingSettings chunkingSettings, Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, LlamaEmbeddingsServiceSettings.fromMap(serviceSettings, context), chunkingSettings, LlamaEmbeddingsModel.retrieveSecretSettings(secrets));
    }

    public LlamaEmbeddingsModel(LlamaEmbeddingsModel model, LlamaEmbeddingsServiceSettings serviceSettings) {
        super((RateLimitGroupingModel)model, serviceSettings);
        this.setPropertiesFromServiceSettings(serviceSettings);
    }

    private void setPropertiesFromServiceSettings(LlamaEmbeddingsServiceSettings serviceSettings) {
        this.uri = serviceSettings.uri();
        this.rateLimitSettings = serviceSettings.rateLimitSettings();
    }

    public LlamaEmbeddingsModel(String inferenceEntityId, TaskType taskType, String service, LlamaEmbeddingsServiceSettings serviceSettings, ChunkingSettings chunkingSettings, SecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)EmptyTaskSettings.INSTANCE, chunkingSettings), new ModelSecrets(secrets));
        this.setPropertiesFromServiceSettings(serviceSettings);
    }

    public LlamaEmbeddingsServiceSettings getServiceSettings() {
        return (LlamaEmbeddingsServiceSettings)super.getServiceSettings();
    }

    @Override
    public ExecutableAction accept(LlamaActionVisitor creator) {
        return creator.create(this);
    }
}

