/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.ccm;

import java.util.Objects;
import java.util.function.Function;
import org.apache.http.client.methods.HttpRequestBase;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.services.elastic.ccm.CCMFeature;
import org.elasticsearch.xpack.inference.services.elastic.ccm.CCMModel;
import org.elasticsearch.xpack.inference.services.elastic.ccm.CCMService;

public class CCMAuthenticationApplierFactory {
    public static final NoopApplier NOOP_APPLIER = new NoopApplier();
    private final CCMFeature ccmFeature;
    private final CCMService ccmService;

    public CCMAuthenticationApplierFactory(CCMFeature ccmFeature, CCMService ccmService) {
        this.ccmFeature = Objects.requireNonNull(ccmFeature);
        this.ccmService = Objects.requireNonNull(ccmService);
    }

    public void getAuthenticationApplier(ActionListener<AuthApplier> listener) {
        if (!this.ccmFeature.isCcmSupportedEnvironment()) {
            listener.onResponse((Object)NOOP_APPLIER);
            return;
        }
        SubscribableListener.newForked(this.ccmService::isEnabled).andThen((ccmModelListener, enabled) -> {
            if (enabled == null || !enabled.booleanValue()) {
                listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Cloud connected mode is not configured, please configure it using PUT {} before accessing the Elastic Inference Service.", RestStatus.BAD_REQUEST, new Object[]{"_inference/_ccm"})));
                return;
            }
            this.ccmService.getConfiguration((ActionListener<CCMModel>)ccmModelListener);
        }).andThenApply(ccmModel -> new AuthenticationHeaderApplier(ccmModel.apiKey())).addListener(listener);
    }

    public record NoopApplier() implements AuthApplier
    {
        @Override
        public HttpRequestBase apply(HttpRequestBase request) {
            return request;
        }
    }

    public record AuthenticationHeaderApplier(SecureString apiKey) implements AuthApplier
    {
        public AuthenticationHeaderApplier(String apiKey) {
            this(new SecureString(Objects.requireNonNull(apiKey).toCharArray()));
        }

        @Override
        public HttpRequestBase apply(HttpRequestBase request) {
            request.setHeader(RequestUtils.createAuthBearerHeader(this.apiKey));
            return request;
        }
    }

    public static interface AuthApplier
    extends Function<HttpRequestBase, HttpRequestBase> {
    }
}

