/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.retry;

import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.inference.results.UnifiedChatCompletionException;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.BaseResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorResponse;
import org.elasticsearch.xpack.inference.external.http.retry.UnifiedChatCompletionErrorParserContract;
import org.elasticsearch.xpack.inference.external.http.retry.UnifiedChatCompletionErrorResponse;
import org.elasticsearch.xpack.inference.external.request.Request;

public class ChatCompletionErrorResponseHandler {
    private static final String STREAM_ERROR = "stream_error";
    private final UnifiedChatCompletionErrorParserContract unifiedChatCompletionErrorParser;

    public ChatCompletionErrorResponseHandler(UnifiedChatCompletionErrorParserContract errorParser) {
        this.unifiedChatCompletionErrorParser = Objects.requireNonNull(errorParser);
    }

    public UnifiedChatCompletionException buildChatCompletionError(String message, Request request, HttpResult result) {
        UnifiedChatCompletionErrorResponse errorResponse = this.unifiedChatCompletionErrorParser.parse(result);
        return this.buildChatCompletionErrorInternal(message, request, result, errorResponse);
    }

    private UnifiedChatCompletionException buildChatCompletionErrorInternal(String message, Request request, HttpResult result, UnifiedChatCompletionErrorResponse errorResponse) {
        assert (request.isStreaming()) : "Only streaming requests support this format";
        int statusCode = result.response().getStatusLine().getStatusCode();
        String errorMessage = BaseResponseHandler.constructErrorMessage(message, request, errorResponse, statusCode);
        RestStatus restStatus = BaseResponseHandler.toRestStatus(statusCode);
        if (errorResponse.errorStructureFound()) {
            return new UnifiedChatCompletionException(restStatus, errorMessage, errorResponse.type(), ChatCompletionErrorResponseHandler.code(errorResponse.code(), restStatus), errorResponse.param());
        }
        return ChatCompletionErrorResponseHandler.buildDefaultChatCompletionError(errorResponse, errorMessage, restStatus);
    }

    private static String code(@Nullable String code, RestStatus status) {
        return code != null ? code : status.name().toLowerCase(Locale.ROOT);
    }

    private static UnifiedChatCompletionException buildDefaultChatCompletionError(ErrorResponse errorResponse, String errorMessage, RestStatus restStatus) {
        return new UnifiedChatCompletionException(restStatus, errorMessage, ChatCompletionErrorResponseHandler.createErrorType(errorResponse), restStatus.name().toLowerCase(Locale.ROOT));
    }

    public UnifiedChatCompletionException buildMidStreamChatCompletionError(String inferenceEntityId, String message, Exception e) {
        UnifiedChatCompletionErrorResponse error = this.unifiedChatCompletionErrorParser.parse(message);
        if (error.errorStructureFound()) {
            return new UnifiedChatCompletionException(RestStatus.INTERNAL_SERVER_ERROR, Strings.format((String)"%s for request from inference entity id [%s]. Error message: [%s]", (Object[])new Object[]{"Received an error response", inferenceEntityId, error.getErrorMessage()}), error.type(), error.code(), error.param());
        }
        if (e != null) {
            return UnifiedChatCompletionException.fromThrowable((Throwable)e);
        }
        return ChatCompletionErrorResponseHandler.buildDefaultMidStreamChatCompletionError(inferenceEntityId, error);
    }

    private static UnifiedChatCompletionException buildDefaultMidStreamChatCompletionError(String inferenceEntityId, ErrorResponse errorResponse) {
        return new UnifiedChatCompletionException(RestStatus.INTERNAL_SERVER_ERROR, Strings.format((String)"%s for request from inference entity id [%s]", (Object[])new Object[]{"Received an error response", inferenceEntityId}), ChatCompletionErrorResponseHandler.createErrorType(errorResponse), STREAM_ERROR);
    }

    private static String createErrorType(ErrorResponse errorResponse) {
        return errorResponse != null ? errorResponse.getClass().getSimpleName() : "unknown";
    }
}

