/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.simdvec.internal.vectorization;

import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import jdk.incubator.vector.VectorShape;
import jdk.incubator.vector.VectorSpecies;
import org.apache.lucene.util.Constants;

public final class PanamaVectorConstants {
    static final int PREFERRED_VECTOR_BITSIZE;
    static final boolean ENABLE_INTEGER_VECTORS;
    static final VectorSpecies<Byte> PREFERRED_BYTE_SPECIES;
    static final VectorSpecies<Integer> PREFERRED_INTEGER_SPECIES;
    static final VectorSpecies<Float> PREFERRED_FLOAT_SPECIES;

    private PanamaVectorConstants() {
    }

    static {
        OptionalInt vs = OptionalInt.empty();
        try {
            vs = Stream.ofNullable(System.getProperty("tests.vectorsize")).filter(Predicate.not(Set.of("", "default")::contains)).mapToInt(Integer::parseInt).findAny();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        int vectorBitSize = VectorShape.preferredShape().vectorBitSize();
        PREFERRED_VECTOR_BITSIZE = vs.orElse(vectorBitSize);
        PREFERRED_BYTE_SPECIES = VectorSpecies.of(Byte.TYPE, (VectorShape)VectorShape.forBitSize((int)PREFERRED_VECTOR_BITSIZE));
        PREFERRED_INTEGER_SPECIES = VectorSpecies.of(Integer.TYPE, (VectorShape)VectorShape.forBitSize((int)PREFERRED_VECTOR_BITSIZE));
        PREFERRED_FLOAT_SPECIES = VectorSpecies.of(Float.TYPE, (VectorShape)VectorShape.forBitSize((int)PREFERRED_VECTOR_BITSIZE));
        boolean isAMD64withoutAVX2 = Constants.OS_ARCH.equals("amd64") && PREFERRED_VECTOR_BITSIZE < 256;
        ENABLE_INTEGER_VECTORS = !isAMD64withoutAVX2 || vs.isPresent();
    }
}

