/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.mapper;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BytesRefsFromBinaryBlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.DoublesBlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.LongsBlockLoader;

public class TDigestBlockLoader
extends BlockDocValuesReader.DocValuesBlockLoader {
    private final DoublesBlockLoader minimaLoader;
    private final DoublesBlockLoader maximaLoader;
    private final DoublesBlockLoader sumsLoader;
    private final LongsBlockLoader valueCountsLoader;
    private final BytesRefsFromBinaryBlockLoader encodedDigestLoader;

    public TDigestBlockLoader(BytesRefsFromBinaryBlockLoader encodedDigestLoader, DoublesBlockLoader minimaLoader, DoublesBlockLoader maximaLoader, DoublesBlockLoader sumsLoader, LongsBlockLoader valueCountsLoader) {
        this.encodedDigestLoader = encodedDigestLoader;
        this.minimaLoader = minimaLoader;
        this.maximaLoader = maximaLoader;
        this.sumsLoader = sumsLoader;
        this.valueCountsLoader = valueCountsLoader;
    }

    public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
        BlockLoader.AllReader encodedDigestReader = this.encodedDigestLoader.reader(context);
        BlockLoader.AllReader minimaReader = this.minimaLoader.reader(context);
        BlockLoader.AllReader maximaReader = this.maximaLoader.reader(context);
        BlockLoader.AllReader sumsReader = this.sumsLoader.reader(context);
        BlockLoader.AllReader valueCountsReader = this.valueCountsLoader.reader(context);
        return new TDigestReader(encodedDigestReader, minimaReader, maximaReader, sumsReader, valueCountsReader);
    }

    public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
        return null;
    }

    static class TDigestReader
    implements BlockLoader.AllReader {
        private final BlockLoader.AllReader encodedDigestReader;
        private final BlockLoader.AllReader minimaReader;
        private final BlockLoader.AllReader maximaReader;
        private final BlockLoader.AllReader sumsReader;
        private final BlockLoader.AllReader valueCountsReader;

        TDigestReader(BlockLoader.AllReader encodedDigestReader, BlockLoader.AllReader minimaReader, BlockLoader.AllReader maximaReader, BlockLoader.AllReader sumsReader, BlockLoader.AllReader valueCountsReader) {
            this.encodedDigestReader = encodedDigestReader;
            this.minimaReader = minimaReader;
            this.maximaReader = maximaReader;
            this.sumsReader = sumsReader;
            this.valueCountsReader = valueCountsReader;
        }

        public boolean canReuse(int startingDocID) {
            return this.minimaReader.canReuse(startingDocID) && this.maximaReader.canReuse(startingDocID) && this.sumsReader.canReuse(startingDocID) && this.valueCountsReader.canReuse(startingDocID) && this.encodedDigestReader.canReuse(startingDocID);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            BlockLoader.Block minima = null;
            BlockLoader.Block maxima = null;
            BlockLoader.Block sums = null;
            BlockLoader.Block valueCounts = null;
            BlockLoader.Block encodedBytes = null;
            boolean success = false;
            try {
                minima = this.minimaReader.read(factory, docs, offset, nullsFiltered);
                maxima = this.maximaReader.read(factory, docs, offset, nullsFiltered);
                sums = this.sumsReader.read(factory, docs, offset, nullsFiltered);
                valueCounts = this.valueCountsReader.read(factory, docs, offset, nullsFiltered);
                encodedBytes = this.encodedDigestReader.read(factory, docs, offset, nullsFiltered);
                return factory.buildTDigestBlockDirect(encodedBytes, minima, maxima, sums, valueCounts);
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                Releasables.close((Releasable[])new Releasable[]{minima, maxima, sums, valueCounts, encodedBytes});
                throw throwable;
            }
        }

        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            BlockLoader.ExponentialHistogramBuilder histogramBuilder = (BlockLoader.ExponentialHistogramBuilder)builder;
            this.minimaReader.read(docId, storedFields, (BlockLoader.Builder)histogramBuilder.minima());
            this.maximaReader.read(docId, storedFields, (BlockLoader.Builder)histogramBuilder.maxima());
            this.sumsReader.read(docId, storedFields, (BlockLoader.Builder)histogramBuilder.sums());
            this.valueCountsReader.read(docId, storedFields, (BlockLoader.Builder)histogramBuilder.valueCounts());
            this.encodedDigestReader.read(docId, storedFields, (BlockLoader.Builder)histogramBuilder.encodedHistograms());
        }

        public String toString() {
            return "BlockDocValuesReader.TDigest";
        }
    }
}

