/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.special;

import org.ojalgo.function.constant.PrimitiveMath;

public abstract class ErrorFunction {
    private static final double[] C = new double[1000];

    public static double erf(double arg) {
        if (arg < -PrimitiveMath.FOUR) {
            return PrimitiveMath.NEG;
        }
        if (arg > PrimitiveMath.FOUR) {
            return PrimitiveMath.ONE;
        }
        double retVal = PrimitiveMath.ZERO;
        double squared = arg * arg;
        for (int n = 0; n <= 100; ++n) {
            double tmpVal = arg / (double)(2 * n + 1);
            for (int i = 1; i <= n; ++i) {
                tmpVal *= -squared / (double)i;
            }
            retVal += tmpVal;
        }
        return PrimitiveMath.TWO * retVal / PrimitiveMath.SQRT_PI;
    }

    public static double erfc(double arg) {
        return PrimitiveMath.ONE - ErrorFunction.erf(arg);
    }

    public static double erfi(double arg) {
        if (Math.abs(arg) > PrimitiveMath.ONE) {
            return Double.NaN;
        }
        if (arg == PrimitiveMath.NEG) {
            return Double.NEGATIVE_INFINITY;
        }
        if (arg == PrimitiveMath.ONE) {
            return Double.POSITIVE_INFINITY;
        }
        double retVal = PrimitiveMath.ZERO;
        double base = PrimitiveMath.SQRT_PI * arg / PrimitiveMath.TWO;
        for (int k = 500; k >= 0; --k) {
            int kk1 = 2 * k + 1;
            double power = Math.pow(base, kk1);
            retVal += C[k] / (double)kk1 * power;
        }
        return retVal;
    }

    private ErrorFunction() {
    }

    static {
        ErrorFunction.C[0] = PrimitiveMath.ONE;
        for (int k = 1; k < C.length; ++k) {
            ErrorFunction.C[k] = PrimitiveMath.ZERO;
            for (int m = 0; m <= k - 1; ++m) {
                int n = k;
                C[n] = C[n] + C[m] * C[k - 1 - m] / (double)((m + 1) * (2 * m + 1));
            }
        }
    }
}

