/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import org.apache.lucene.geo.GeoEncodingUtils;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;

public class GeoTileBoundedPredicate {
    private final boolean crossesDateline;
    private final long maxTiles;
    private final int precision;
    private final int leftX;
    private final int rightX;
    private final int minY;
    private final int maxY;

    public GeoTileBoundedPredicate(int precision, GeoBoundingBox bbox) {
        this.crossesDateline = bbox.right() < bbox.left();
        this.precision = precision;
        if (bbox.bottom() > GeoTileUtils.NORMALIZED_LATITUDE_MASK || bbox.top() < GeoTileUtils.NORMALIZED_NEGATIVE_LATITUDE_MASK) {
            this.maxY = -1;
            this.minY = -1;
            this.rightX = -1;
            this.leftX = -1;
            this.maxTiles = 0L;
        } else {
            int minY;
            int tiles = 1 << precision;
            int minX = GeoTileUtils.getXTile(bbox.left(), tiles);
            Rectangle minTile = GeoTileUtils.toBoundingBox(minX, minY = GeoTileUtils.getYTile(bbox.top(), tiles), precision);
            this.leftX = GeoEncodingUtils.encodeLongitude((double)minTile.getMaxX()) == GeoEncodingUtils.encodeLongitude((double)bbox.left()) ? minX + 1 : minX;
            this.minY = GeoEncodingUtils.encodeLatitude((double)minTile.getMinY()) == GeoEncodingUtils.encodeLatitude((double)bbox.top()) ? minY + 1 : minY;
            int maxX = GeoTileUtils.getXTile(bbox.right(), tiles);
            int maxY = GeoTileUtils.getYTile(bbox.bottom(), tiles);
            Rectangle maxTile = GeoTileUtils.toBoundingBox(maxX, maxY, precision);
            this.rightX = GeoEncodingUtils.encodeLongitude((double)maxTile.getMinX()) == GeoEncodingUtils.encodeLongitude((double)bbox.right()) ? maxX : maxX + 1;
            this.maxY = GeoEncodingUtils.encodeLatitude((double)maxTile.getMaxY()) == GeoEncodingUtils.encodeLatitude((double)bbox.bottom()) ? maxY : maxY + 1;
            this.maxTiles = this.crossesDateline ? ((long)tiles + (long)this.rightX - (long)this.leftX) * (long)(this.maxY - this.minY) : (long)(this.rightX - this.leftX) * (long)(this.maxY - this.minY);
        }
    }

    public boolean crossesDateline() {
        return this.crossesDateline;
    }

    public int leftX() {
        return this.leftX;
    }

    public int rightX() {
        return this.rightX;
    }

    public int minY() {
        return this.minY;
    }

    public int maxY() {
        return this.maxY;
    }

    public boolean validTile(int x, int y, int precision) {
        assert (this.precision >= precision) : "input precision bigger than this predicate precision";
        int splits = 1 << this.precision - precision;
        int yMin = y * splits;
        if (this.maxY > yMin && this.minY < yMin + splits) {
            int xMin = x * splits;
            if (this.crossesDateline) {
                return this.rightX > xMin || this.leftX < xMin + splits;
            }
            return this.rightX > xMin && this.leftX < xMin + splits;
        }
        return false;
    }

    public long getMaxTiles() {
        return this.maxTiles;
    }
}

